#ifndef DRIVER_H
#define DRIVER_H

#include <QObject>
#include <QLibrary>
#include <QDebug>
#include <QDomDocument>
#include <QDomElement>
//#include <QtDBus/QtDBus>
#include <QtDBus>
#include "request.h"
#include "profile.h"
#include "mysocials_driver.h"
#include "config.h"

#define REGEXP_PARAM "regexp"
#define TITLE_PARAM "title"
#define CLIENT_ID_PARAM "ClientID"
#define ACCOUNT_ID_PARAM "accountID_RET"
#define ACCOUNT_ID_NAME "accountID"
#define RESULT_NAME_AUTH "authResult"
#define RESULT_NAME_CAPTCHA "captchaResult"



class  Driver : public QObject
{
    Q_OBJECT

public:
    /**
      \brief Default constructor.

      \param parent Pointer to parent object.
      */
    Driver();

    /**
      \brief Destructor.
      */
    ~Driver();
    Request *request;
    QNetworkAccessManager *manager;
    QDBusInterface authInterface;
    void authorize(Request* request, MysocialsDrv *drv);
    void executeRequest();
    void setRequest(Request* request, MysocialsDrv *drv);
    void callWebauth();
signals:
    void requestProcessed(QDomDocument* response);
public slots:
    void gotResponse();
    void replyFinished(QNetworkReply*);
    void authFinished(const QStringList &result);
};






#endif // DRIVER_H
