<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">audio</xsl:attribute>
        <xsl:attribute name="function">getAudio</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$STRUCT}">
                <xsl:attribute name="name">audio</xsl:attribute>
                <xsl:attribute name="id">
                    <xsl:text>vk</xsl:text>
                <xsl:value-of select="audio/aid"/>
                </xsl:attribute>
                <xsl:attribute name="ownerId">
                    <xsl:text>vk</xsl:text>
                    <xsl:value-of select="audio/owner_id"/>
                </xsl:attribute>                             

         
                <xsl:element name="{$STRING}">
                   <xsl:attribute name="name">title</xsl:attribute>
                   <xsl:value-of select="audio/title"/>
                </xsl:element>

                <xsl:element name="{$STRING}">
                    <xsl:attribute name="name">artist</xsl:attribute>
                    <xsl:value-of select="audio/artist"/>
                </xsl:element>

                <xsl:element name="{$NUMBER}">
                    <xsl:attribute name="name">duration</xsl:attribute>
                    <xsl:value-of select="audio/duration"/>
                </xsl:element>

                <xsl:element name="{$STRING}">
                    <xsl:attribute name="name">audio</xsl:attribute>
                    <xsl:value-of select="audio/url"/>
                </xsl:element>

            </xsl:element>

        </xsl:element> 
    </xsl:element> 
</xsl:template>

</xsl:stylesheet>
