#include "driver.h"


Driver::Driver() : authInterface("org.lomalan.AuthManager", QString("/AuthManager"), "org.lomalan.AuthManager")
{
    this->manager = new QNetworkAccessManager(this);
    connect(this->manager, SIGNAL(finished(QNetworkReply*)),
          this, SLOT(replyFinished(QNetworkReply*)));

}

Driver::~Driver()
{
}


void Driver::gotResponse()
{
    qDebug()<<"gotResponse";
    if(!this->request->request.isNull()){
        request->processRequest();
        this->executeRequest();
    } else if(this->request->nextRequest != NULL){
        this->request = this->request->nextRequest;
        this->request->nextRequest = NULL;
        connect(this->request,SIGNAL(gotResponse()),this,SLOT(gotResponse()));
        request->processRequest();
        this->executeRequest();
    } else
        emit requestProcessed(&request->response);

}

void Driver::setRequest(Request *request, MysocialsDrv *drv)
{
    qDebug()<<"setRequest ";

    QString parser("test.xsl");

    //initialization of request
    request->setProxy(drv->proxy, drv->port);
    if(Profile::getProfileById(drv->id) == NULL)
        qDebug()<<"profile not found";
    request->setProfile(Profile::getProfileById(drv->id));
    //check authorization

    QString function = request->request.documentElement().
            attribute("function").trimmed();
    qDebug()<<"function = "<<function;

    if(!Profile::getProfileById(drv->id)->isAuthorised()
            && function.compare(GET_SETTINGS) != 0){
        this->authorize(request, drv);
    } else {
        this->request = request;
    }
        this->request->processRequest();
        connect(this->request,SIGNAL(gotResponse()),this,SLOT(gotResponse()));

}

void Driver::authorize(Request *request, MysocialsDrv *drv){
    QDomDocument authRequest;
    authRequest.setContent(QString(AUTH_REQUEST),1,NULL,NULL,NULL);
    Request *req = new Request(&authRequest);
    //initialization of request
    req->setProxy(drv->proxy, drv->port);
    req->setProfile(Profile::getProfileById(drv->id));
    req->nextRequest = request;
    this->request = req;
}

void Driver::executeRequest()
{
    qDebug()<<"execute request";
    if(this->request->request.isNull()){
        qDebug()<<"Error! request is Null!";
        return;
    }
    qDebug()<<this->request->request.toString(1);
    if(this->request->type.compare("webauth") == 0){
        this->callWebauth();
        //data = call_webauth(url, pr);
    } else if(this->request->type.compare("webcaptcha") == 0){
        //data = call_webcaptcha(url, pr);
        /*
        http_code = http_get(url, info_proxy, info_port, &data, &data_size);
        if(http_code < 300){
            strBase64 = g_base64_encode(data, data_size);
            g_free(data);
            data = call_webcaptcha(strBase64, pr);
        }
        */
    } else if(this->request->type.compare("get") == 0 || this->request->type.compare("download") == 0){

        if(this->manager->networkAccessible()) {
            qDebug()<<"All ok";
            this->manager->get(QNetworkRequest(QUrl(request->url)));
        }
        else {
            qDebug()<<"No network";
            //emit network error
        }

        //http_code = http_get(url, info_proxy, info_port, &data, &data_size);
    } else if(this->request->type.compare("post") == 0){
        //post_data = g_strsplit(url,"?",2);
        //http_code = http_post(post_data[0], info_proxy, info_port, post_data[1], &data, &data_size);
        //g_strfreev(post_data);
    } else if(this->request->type.compare("upload") == 0){
        /*
        msa_debug("UPLOADING...");
        file = (struct UpFile *)malloc(sizeof (struct UpFile));
        node = xpath_get_node("//InnerRequest/name", inner_req);
        file->name = (gchar*)xmlNodeGetContent(node);
        node = xpath_get_node("//InnerRequest/file", inner_req);
        file->file_path = (gchar*)xmlNodeGetContent(node);
        node = xpath_get_node("//InnerRequest/file_name", inner_req);
        file->file_name = (gchar*)xmlNodeGetContent(node);

        post_data = g_strsplit_set(url, "?", 2);
        if(post_data[1] != NULL)
            file->params = g_strsplit_set(post_data[1], "&=", 100);
        else
            file->params = NULL;
        http_code = http_upload_file(post_data[0], info_proxy, info_port, &data, file);
        upfile_remove(file);
        g_strfreev(post_data);
        */
    }

}

void Driver::replyFinished(QNetworkReply* reply)
{
    qDebug()<<"replyFinished";
    QByteArray data;
    data = reply->readAll();
    QString str(data);

    qDebug()<<"GET DATA"<<endl<<str;
    this->request->parseResponse(data);
}

void Driver::callWebauth(){
    QDBusConnection::sessionBus().connect(QString(), QString(), "org.lomalan.AuthManager", DRIVER_ID,
                                           (QObject*)this, SLOT(authFinished(QStringList)));
    authInterface.call("SetProxy", this->request->proxy, this->request->port, "", "");

    QStringList params;

    params.append(TITLE_PARAM);
    params.append(this->request->profile->id);
    params.append(ACCOUNT_ID_PARAM);
    params.append(this->request->profile->id);
    params.append(REGEXP_PARAM);
    params.append(LOGIN_SUCCESS);
    params.append(CLIENT_ID_PARAM);
    params.append(DRIVER_ID);

    QDBusReply<QString> repl = authInterface.call("Auth", this->request->url, params);

    if (repl.isValid() == true) {
        qDebug()<< "\nAuth data send...\n";
    } else {
        qDebug()<< "\nCan't send auth data...(" << repl.error().message().toAscii().constData() << ")\n";
    }

}

void Driver::authFinished(const QStringList &result){

    qDebug()<<"authFinished";

    int len = result.length() - 1;

    if(result[0].compare(RESULT_NAME_AUTH) == 0
        && result[2].compare(ACCOUNT_ID_NAME) == 0
        && result[3].compare(this->request->profile->id) == 0) {
        qDebug()<<"auth result= "<<result[1];
        this->request->parseResponse(result[1].toAscii());

    } else if (result[0].compare(RESULT_NAME_CAPTCHA) == 0){
        qDebug()<<"captcha result= "<<result[1];

    }

}
