/*
 * parser.c -  parser for MySocials driver
 * This file is part of MSA program
 *
 * Copyright (C) 2009, 2010, 2011 - MySocials team
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */
#include "parser.h"

/**
 * Parses json data
 *
 * @param json - data in json format
 * @return 0 - on success, 1 other
 */
#ifndef NOT_USE_DEFAULT_JSON_PARSER
int json_parser(xmlDocPtr inner_req, const struct ProfileData *cp, gchar* data, int data_size, gchar **response)
{
    struct json_object *buf = NULL;
    gchar* resp_str = NULL;
    gchar* tmp_str = NULL;
    char *key; struct json_object *val; struct lh_entry *entry;

    MSA_UNUSED(inner_req);
    MSA_UNUSED(cp);
    MSA_UNUSED(data_size);

    if(data != NULL) {
        buf = json_tokener_parse(data);
        if(buf != NULL) {
            if (is_error(buf)){
                *response = NULL;
                return 1;
            }
            tmp_str = g_strconcat("<?xml version=\"1.0\"?>", "<response>", NULL);

            /*json_object_object_foreach(buf, key, val)*/
            for(entry = json_object_get_object(buf)->head; (entry ? (key = (char*)entry->k, val = (struct json_object*)entry->v, entry) : 0); entry = entry->next)  {

                resp_str = g_strconcat(tmp_str, "<", key, ">",
                                            json_object_get_string(val), 
                                            "</", key, ">", NULL);
                g_free(tmp_str);
                tmp_str = resp_str;
            }
            resp_str = g_strconcat(tmp_str, "</response>", NULL);
            g_free(tmp_str);
            *response = resp_str;
            json_object_put(buf);
            return 0;
         } 
                
    }
    *response = NULL;
    return 1;
}
#endif

#ifndef NOT_USE_DEFAULT_SETTINGS_PARSER
int settings_parser(xmlDocPtr inner_req, struct ProfileData *cp, gchar* data, int data_size, gchar **response)
{
    MSA_UNUSED(data);
    MSA_UNUSED(data_size);

    if(profile_update(cp, inner_req) == 0)
        *response = g_strdup(MSG_INFO);
    else
        *response = g_strdup(MSG_SETTINGS_SAVED_ERROR);
    msa_debug("settings_parser: END");
    return 0;
}
#endif

#ifndef NOT_USE_DEFAULT_EMPTY_PARSER
int empty_parser(xmlDocPtr inner_req, const struct ProfileData *cp, gchar* data, int data_size, gchar **response)
{
    MSA_UNUSED(inner_req);
    MSA_UNUSED(cp);
    MSA_UNUSED(data);
    MSA_UNUSED(data_size);

    *response = g_strdup(RESPONSE_EMPTY);
    return 0;
}
#endif

#ifndef NOT_USE_DEFAULT_DOWNLOAD_PARSER
int download_parser(xmlDocPtr inner_req, const struct ProfileData *cp, gchar* data, int data_size, gchar **response)
{
    xmlNodePtr node = NULL;
    gchar* path = NULL;

    MSA_UNUSED(cp);

    node = xpath_get_node("//*/Params/string[@name='path']", inner_req);
    if (node == NULL){
        *response = g_strdup(MSG_FILE_SAVE_ERROR);
        return 1;
    }
    path = (gchar *)xmlNodeGetContent(node);
    msa_debug("try save file to \"%s\"", path);
    if (path != NULL)
    {
        if(g_file_set_contents(path, data, data_size, NULL)){
            msa_debug("write to file");
            *response = g_strdup(MSG_INFO);
            g_free(path);
            return 0;
        }
    } 
    *response = g_strdup(MSG_FILE_SAVE_ERROR);
    g_free(path);
    return 1;
}
#endif

#ifndef NOT_USE_DEFAULT_TEXT_PARSER
int text_parser(xmlDocPtr inner_req, const struct ProfileData *cp, gchar* data, int data_size, gchar **response)
{
    *response = g_strdup(data);
    return 0;
}
#endif

#ifndef NOT_USE_DEFAULT_WEBAUTH_PARSER
int webauth_parser(xmlDocPtr inner_req, const struct ProfileData *cp, gchar* data, int data_size, gchar **response)
{
    *response = g_strdup(data);
    return 0;
}
#endif

#ifndef NOT_USE_DEFAULT_PROCESS_URL
void process_url(xmlDocPtr inner_req, const struct ProfileData *cp, gchar* data, int data_size, gchar **response)
{
    *response = g_strdup(data);
}
#endif

