<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">photos</xsl:attribute>
        <xsl:attribute name="function">getListAlbums</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$ARRAY}">
                <xsl:attribute name="name">albumList</xsl:attribute>
                <xsl:attribute name="quantity">
                    <xsl:value-of select="count(albums/item)"/>
                </xsl:attribute>                             
                <xsl:attribute name="ownerId">
                    <xsl:text>vk</xsl:text>
                    <xsl:value-of select="albums/item/owner_id"/>
                </xsl:attribute>                             
   
                <xsl:for-each select="albums/item">
                    <xsl:element name="{$STRUCT}">
                        <xsl:attribute name="name">album</xsl:attribute>
                        <xsl:attribute name="id">
                            <xsl:text>vk</xsl:text>
                        <xsl:value-of select="aid"/>
                        </xsl:attribute>
                 
                        <xsl:element name="{$STRING}">
                           <xsl:attribute name="name">title</xsl:attribute>
                           <xsl:value-of select="title"/>
                        </xsl:element>

                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">description</xsl:attribute>
                            <xsl:value-of select="description"/>
                        </xsl:element>


                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">thumbId</xsl:attribute>
                            <xsl:text>vk</xsl:text>
                            <xsl:value-of select="thumb_id"/>
                        </xsl:element>

                        <xsl:if test="thumb_id">
                            <xsl:if test="thumb_id != '0'">
                                <xsl:variable name="current_aid" select="position()"/>
                                <xsl:element name="{$IMG}">
                                    <xsl:attribute name="name">Img</xsl:attribute>
                                        <xsl:value-of select="//icons/item[number($current_aid)]"/>
                                </xsl:element>
                            </xsl:if>
                        </xsl:if>
                        <xsl:element name="{$NUMBER}">
                            <xsl:attribute name="name">created</xsl:attribute>
                            <xsl:value-of select="created"/>
                        </xsl:element>

                        <xsl:element name="{$NUMBER}">
                            <xsl:attribute name="name">updated</xsl:attribute>
                            <xsl:value-of select="updated"/>
                        </xsl:element>

                        <xsl:element name="{$NUMBER}">
                            <xsl:attribute name="name">size</xsl:attribute>
                            <xsl:value-of select="size"/>
                        </xsl:element>

                    </xsl:element>
                </xsl:for-each>
            </xsl:element> 

        </xsl:element> 
    </xsl:element> 
</xsl:template>

</xsl:stylesheet>
