/*
 * parser.c -  parser for driver vkontakte of MSA program
 * This file is part of MSA program
 *
 * Copyright (C) 2009 - Sergey Zakharov
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */
#include "parser.h"

/**
 * Parses json data
 *
 * @param json - data in json format
 * @return 0 - on success, 1 other
 */
int parse_upload(char* json, gchar **response)
{
    struct json_object *buf = NULL;
    gchar* resp_str = NULL;
    gchar* tmp_str = NULL;
    
    if(json != NULL) {
        buf = json_tokener_parse(json);
        if(buf != NULL) {
            if (is_error(buf)){
                *response = NULL;
                return 1;
            }
            tmp_str = g_strconcat("<?xml version=\"1.0\"?>", "<response>", NULL);

            json_object_object_foreach(buf, key, val) {

                resp_str = g_strconcat(tmp_str, "<", key, ">",
                                            json_object_get_string(val), 
                                            "</", key, ">", NULL);
                g_free(tmp_str);
                tmp_str = resp_str;
            }
            resp_str = g_strconcat(tmp_str, "</response>", NULL);
            g_free(tmp_str);
            *response = resp_str;
            json_object_put(buf);
            return 0;
         } 
                
    }
    *response = NULL;
    return 1;
}

