<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="URL" select="'url'"/>
<xsl:variable name="SIG" select="'sig'"/>
<xsl:variable name="INNER_REQUEST" select="'InnerRequest'"/>
<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:variable name="FUNCTION" select="/Request/@function"/>  
<xsl:variable name="PARAMS2" select="document('requests.xml')//requests/request[(@function=$FUNCTION) or (@function='general')]"/>  


<xsl:include href="errors.xsl"/>

<xsl:template match="/response">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">photos</xsl:attribute>
        <xsl:attribute name="function">getPhotoComments</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:attribute name="id">
                <xsl:text>vk</xsl:text>
                <xsl:value-of select="$MID"/>
            </xsl:attribute>

            <xsl:element name="{$ARRAY}">
                <xsl:variable name="quantity" select="count(/response/comments/item)"/>
                <xsl:variable name="offset" select="offset"/> 

                <xsl:attribute name="name">commentsList</xsl:attribute>

                <xsl:attribute name="from">
                    <xsl:if test="not(number($offset))">
                        <xsl:value-of select="'0'"/> 
                    </xsl:if>
                    <xsl:if test="number($offset)">
                        <xsl:value-of select="offset"/> 
                    </xsl:if>                 
                </xsl:attribute>
                <xsl:attribute name="to">
                    <xsl:if test="not(number($offset))">
                        <xsl:value-of select="number($quantity) - 1"/>
                    </xsl:if>
                    <xsl:if test="number($offset)">
                        <xsl:value-of select="number($offset) + number($quantity) - 1"/>
                    </xsl:if>                
                </xsl:attribute>

                <xsl:attribute name="ownerId">
                    <xsl:text>vk</xsl:text>
                    <xsl:value-of select="/response/owner_id"/>
                </xsl:attribute>

                <xsl:attribute name="albumId">
                    <xsl:text>vk</xsl:text>
                    <xsl:value-of select="/response/album_id"/>
                </xsl:attribute>

                <xsl:attribute name="photoId">
                    <xsl:text>vk</xsl:text>
                    <xsl:value-of select="/response/photo_id"/>
                </xsl:attribute>

                <xsl:apply-templates select="/response/comments/item"/>
            </xsl:element> 

        </xsl:element> 
    </xsl:element> 
</xsl:template>


<xsl:template match="item">
    <xsl:if test="cid">
        <xsl:element name="{$STRUCT}">
            <xsl:attribute name="name">comment</xsl:attribute>
            <xsl:attribute name="id">
                <xsl:text>vk</xsl:text>
            <xsl:value-of select="cid"/>
            </xsl:attribute>

            <xsl:element name="{$STRING}">
               <xsl:attribute name="name">SenderId</xsl:attribute>
                <xsl:text>vk</xsl:text>
               <xsl:value-of select="from_id"/>
            </xsl:element>

            <xsl:if test="from_id">
                <xsl:if test="from_id != '0'">
                	<xsl:variable name="current_uid" select="from_id"/>
                    <xsl:element name="{$STRING}">
                       <xsl:attribute name="name">SenderName</xsl:attribute>
                            <xsl:value-of select="//sender/item[uid=$current_uid]/first_name"/>
                            <xsl:text> </xsl:text>
                            <xsl:value-of select="//sender/item[uid=$current_uid]/last_name"/>
                    </xsl:element>
                </xsl:if>
            </xsl:if>


            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">Time</xsl:attribute>
                <xsl:value-of select="date"/>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">Text</xsl:attribute>
                <xsl:value-of select="message"/>
            </xsl:element>

        </xsl:element>
    </xsl:if>
</xsl:template>
</xsl:stylesheet>
