/*
 * driver.h -  driver vkontakte of MSA program
 * This file is part of MSA program.
 *
 * Copyright (C) 2009 - Sergey Zakharov
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */
#ifndef _DRIVER_H_
#define _DRIVER_H_

#define UAGENT "VKontakte Agent 1.0"
#define PAGE_SIZE 20
#define PREFIX "vk"
#define MAX_COUNTER 200
#define MID_SIZE 100
#define URL_SIZE 1024

//functions
#define GET_LIST_FRIENDS "updateListFriends"
#define SEND_MY_PROFILE "setProfile"
#define GET_MY_PROFILE "getProfile"
#define UPDATE_PROFILE "updateProfile"
#define GET_SETTINGS "getSettings"
#define SET_SETTINGS "setSettings"
#define SEND_MESSAGE "sendMessage"
#define SEND_WALL_MESSAGE "sendWallMessage"
#define GET_BINARY_DATA "getBinaryData"
#define CAPTCHA_MESSAGE "captchaMessage"
#define DELETE_FRIEND "deleteFriend"
#define DELETE_MESSAGE "deleteMessage"

#define PARAMS "Params"
#define ERROR "error"
#define CLASS "class"
#define FUNCTION "function"

#include <unistd.h>
#include <libxml/encoding.h>
#include <libxml/xmlwriter.h>
#include <libxml/tree.h>
#include <libxml/xmlmemory.h>
#include <libxml/debugXML.h>
#include <libxml/HTMLtree.h>
#include <libxml/xmlIO.h>
//#include <libxml/DOCBparser.h>
#include <libxml/xinclude.h>
#include <libxml/catalog.h>
#include <libxslt/xslt.h>
#include <libxslt/xsltInternals.h>
#include <libxslt/transform.h>
#include <libxslt/xsltutils.h>

#include <string.h>
#include <glib.h>
#include <time.h>
#include <curl/curl.h>
#include <curl/types.h>
#include <curl/easy.h>
#include <glib/gprintf.h>

/* get system proxy from gconf (linux) */
#include <gconf/gconf-client.h>

#include "vkontakte.h"
#include "profile.h"

#define REQ "request.xml"
#define AUTH "auth.xml"
#define UTF8 "utf-8"
#define CP1251 "cp1251"
#define STRING "string"
#define IMG "img"
#define BOOLEAN "boolean"
#define NUMBER "number"
#define NAME "name"
#define LOGIN "login"
#define PASSWORD "password"

/* get system proxy from gconf (linux) */
#define GCONF_PROXY_HOST "/system/http_proxy/host"
#define GCONF_PROXY_PORT "/system/http_proxy/port"
#define GCONF_PROXY_USE "/system/http_proxy/use_http_proxy"

gchar *info_proxy;
gint info_port;

struct MemoryStruct {
    char* memory;
    size_t size;
};

/*
 * Struct contains information of file for upload.
 */
struct UpFile {
    gchar *name;
    gchar *file_path;
    gchar *file_name;
};

void upfile_remove(struct UpFile *file);
void* myrealloc(void* ptr, size_t size);
int authorize(struct ProfileData *cp);
int initialization(struct ProfileData *cp);
int vk_req(xmlDocPtr reqXml, xmlDocPtr* doc, const struct msa_module* info);
xmlChar* get_req_class(xmlDocPtr reqXml);
xmlChar* get_req_function(xmlDocPtr reqXml);
int http_get(const char* url, const char* proxy, const int port, char** header, gchar** body, int* data_size);
int http_upload_file(const char* url, const char* proxy, const int port, char** header, gchar** body, struct ProfileData *cp, struct UpFile *file);
int http_post(const char* url, const char* proxy, const int port, char* post_data, char** header, char** body, struct curl_slist** cookies);
int get_settings(xmlDocPtr doc, const struct ProfileData *cp);
int set_settings(xmlDocPtr reqXml, struct ProfileData *cp);
int info_message(char* code, xmlDocPtr doc, char* message, int type);
xmlXPathObject* xpath(char* req, xmlDocPtr doc);
xmlNodePtr xpath_get_node(char* path, xmlDocPtr doc);

int parse_auth(struct ProfileData *pr, char *back_url);
xmlDocPtr apply_parser(xmlDocPtr request, gchar* parser, struct ProfileData *pr);
int process_request(struct ProfileData *pr, xmlDocPtr request, xmlDocPtr* response);
int process_inner_request(struct ProfileData *pr, xmlDocPtr inner_req);
int save_file (xmlDocPtr reqXml, char* data, int data_size);
int close_tags(gchar* data);
#endif
