<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="//response">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">systemMessages</xsl:attribute>
        <xsl:attribute name="function">infoMessage</xsl:attribute>
        <xsl:element name="{$PARAMS}">
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">moduleName</xsl:attribute>
                <xsl:text>vkontakte</xsl:text>
            </xsl:element> 

            <xsl:if test="//response = '1'">
                <xsl:element name="{$STRING}">
                    <xsl:attribute name="name">code</xsl:attribute>
                    <xsl:text>415</xsl:text>
                </xsl:element> 
                <xsl:element name="{$STRING}">
                    <xsl:attribute name="name">text</xsl:attribute>
                    <xsl:text>Message mark as read</xsl:text>
                </xsl:element> 
            </xsl:if>
        </xsl:element>
        </xsl:element>
</xsl:template>

</xsl:stylesheet>
