<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="URL" select="'url'"/>
<xsl:variable name="SIG" select="'sig'"/>
<xsl:variable name="INNER_REQUEST" select="'InnerRequest'"/>
<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:variable name="FUNCTION" select="/Request/@function"/>  
<xsl:variable name="PARAMS2" select="document('requests.xml')//requests/request[(@function=$FUNCTION) or (@function='general')]"/>  


<xsl:include href="errors.xsl"/>

<xsl:template match="/response">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">photos</xsl:attribute>
        <xsl:attribute name="function">getPhotos</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$ARRAY}">
                <xsl:attribute name="name">photosList</xsl:attribute>
                <xsl:attribute name="quantity">
                    <xsl:value-of select="count(/response/photos/item)"/>
                </xsl:attribute>
                <xsl:attribute name="ownerId">
                    <xsl:text>vk</xsl:text>
                    <xsl:value-of select="/response/owner_id"/>
                </xsl:attribute>

                <xsl:attribute name="albumId">
                    <xsl:text>vk</xsl:text>
                    <xsl:value-of select="/response/album_id"/>
                </xsl:attribute>

                <xsl:for-each select="/response/photos/item">
                    <xsl:element name="{$STRUCT}">
                        <xsl:attribute name="name">photo</xsl:attribute>
                        <xsl:attribute name="id">
                            <xsl:text>vk</xsl:text>
                        <xsl:value-of select="pid"/>
                        </xsl:attribute>

                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">albumId</xsl:attribute>
                            <xsl:text>vk</xsl:text>
                            <xsl:value-of select="aid"/>
                        </xsl:element>

                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">ownerId</xsl:attribute>
                            <xsl:text>vk</xsl:text>
                            <xsl:value-of select="owner_id"/>
                        </xsl:element>

                        <xsl:element name="{$STRING}">
                           <xsl:attribute name="name">urlSmall</xsl:attribute>
                           <xsl:value-of select="src"/>
                        </xsl:element>

                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">urlBig</xsl:attribute>
                            <xsl:value-of select="src_big"/>
                        </xsl:element>

                        <xsl:element name="{$NUMBER}">
                            <xsl:attribute name="name">created</xsl:attribute>
                            <xsl:value-of select="created"/>
                        </xsl:element>
                    </xsl:element>
                </xsl:for-each>
            </xsl:element> 

        </xsl:element> 
    </xsl:element> 
</xsl:template>
</xsl:stylesheet>
