<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="URL" select="'url'"/>
<xsl:variable name="SIG" select="'sig'"/>
<xsl:variable name="INNER_REQUEST" select="'InnerRequest'"/>
<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:variable name="FUNCTION" select="/Request/@function"/>  
<xsl:variable name="PARAMS2" select="document('requests.xml')//requests/request[(@function=$FUNCTION) or (@function='general')]"/>  


<xsl:include href="errors.xsl"/>

<xsl:template match="/response">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">friends</xsl:attribute>
        <xsl:attribute name="function">updateListFriends</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:attribute name="id">
                <xsl:text>vk</xsl:text>
                <xsl:value-of select="$MID"/>
            </xsl:attribute>

            <xsl:element name="{$ARRAY}">
                <xsl:variable name="quantity" select="count(/response/friends/item)"/>
                <xsl:variable name="offset" select="offset"/> 

                <xsl:attribute name="name">ContactList</xsl:attribute>
                <xsl:attribute name="from">
                    <xsl:if test="not(number($offset))">
                        <xsl:value-of select="'0'"/> 
                    </xsl:if>
                    <xsl:if test="number($offset)">
                        <xsl:value-of select="offset"/> 
                    </xsl:if>                 
                </xsl:attribute>
                <xsl:attribute name="to">
                    <xsl:if test="not(number($offset))">
                        <xsl:value-of select="number($quantity)"/>
                    </xsl:if>
                    <xsl:if test="number($offset)">
                        <xsl:value-of select="number($offset) + number($quantity)"/>
                    </xsl:if>                
                </xsl:attribute>
                <xsl:apply-templates select="/response/friends/*"/>
            </xsl:element> 

        </xsl:element> 
    </xsl:element> 
</xsl:template>


<xsl:template match="item">

    <xsl:element name="{$STRUCT}">
        <xsl:attribute name="name">Contact</xsl:attribute>
        <xsl:attribute name="id">
            <xsl:text>vk</xsl:text>
        <xsl:value-of select="uid"/>
        </xsl:attribute>

 
        <xsl:element name="{$STRING}">
           <xsl:attribute name="name">FirstName</xsl:attribute>
           <xsl:value-of select="first_name"/>
        </xsl:element>

        <xsl:element name="{$STRING}">
            <xsl:attribute name="name">LastName</xsl:attribute>
            <xsl:value-of select="last_name"/>
        </xsl:element>

        <xsl:element name="{$STRING}">
            <xsl:attribute name="name">FriendStatus</xsl:attribute>
            <xsl:value-of select="online"/>
        </xsl:element>

        <xsl:element name="{$IMG}">
            <xsl:attribute name="name">FriendImg</xsl:attribute>
            <xsl:attribute name="uri">
                <xsl:value-of select="photo_medium"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:element>
</xsl:template>
</xsl:stylesheet>
