/*
 * profile.c - methods and structs for work with profile data
 * This file is part of libvkontakte library
 *
 * Copyright (C) 2010 - Kirill Kulakov
 *
 * libvkontakte library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libvkontakte library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libvkontakte library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */
 
#include <stdlib.h>
#include <string.h>

#include "profile.h"

/**
 * Create empty profile with id.
 *
 * @param name - string for identify current module
 * @return new profile entity
 */
struct ProfileData *profile_create(gchar *name)
{
    struct ProfileData *ret = (struct ProfileData *)malloc(sizeof (struct ProfileData));
    int num_accounts = 0; /* number of exist accounts */
    int id_busy = 0;
 
    if (profile_list == NULL) {
    	profile_list = ret;
    } else {
        struct ProfileData *last = (struct ProfileData *)profile_list;
        while(last->next != NULL) {
            if(g_strcmp0(last->id, name) == 0) {
                id_busy = 1;
            }
            num_accounts++;
            last = last->next;
        }
        last->next = ret;
    }
    
    if(id_busy)
        ret->id = g_strdup_printf("%s%d", name, num_accounts);
    else
        ret->id = g_strdup_printf("%s", name);

    ret->login = NULL;
    ret->password = NULL;
    ret->remixmid = NULL;
    ret->remixsid = NULL;
    ret->secret = NULL;
    ret->next = NULL;

    return ret;
}

/**
 * remove selected profile
 *
 * @param data - pointer to selected profile
 */
void profile_remove(struct ProfileData *data)
{
    if (data->id != NULL)
	g_free(data->id);
    if (data->login != NULL)
	g_free(data->login);
    if (data->password != NULL)
	g_free(data->password);
    if (data->remixmid != NULL)
	g_free(data->remixmid);
    if (data->remixsid != NULL)
	g_free(data->remixsid);
    if (data->secret != NULL)
	g_free(data->secret);


    free(data);
}

/**
 * Find profile in list, contains selected id.
 *
 * @param id - string which profile contains
 * @return found profile entity or NULL
 */
const struct ProfileData *profile_get_by_id(gchar *id)
{
    const struct ProfileData *ret = profile_list;
    while(ret != NULL)
    {
	msa_debug("%s:%d:%s: cur_id=%s, list_id=%s", __FILE__, __LINE__, __FUNCTION__, id, ret->id);
	if (!strcmp(ret->id, id))
	    return ret;
        ret = ret->next;
    }

    return ret;
}

