<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="URL" select="'url'"/>
<xsl:variable name="SIG" select="'sig'"/>
<xsl:variable name="INNER_REQUEST" select="'InnerRequest'"/>
<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:variable name="FUNCTION" select="/Request/@function"/>  
<xsl:variable name="PARAMS2" select="document('requests.xml')//requests/request[(@function=$FUNCTION) or (@function='general')]"/>  


<xsl:include href="errors.xsl"/>

<xsl:template match="/response">
<xsl:if test="/response/icons/item and /response/owners/item">
    <xsl:element name="{$REQUEST}">
        <xsl:attribute name="class">photos</xsl:attribute>
        <xsl:attribute name="function">getAlbumsWithIcons</xsl:attribute>
        <xsl:element name="{$PARAMS}">
            <xsl:attribute name="id">
                <xsl:text>vk</xsl:text>
                <xsl:value-of select="//owners/item"/>
            </xsl:attribute>

                <xsl:element name="{$STRING}">
                    <xsl:attribute name="name">icons</xsl:attribute>
                        <xsl:for-each select="/response/icons/item">
                            <xsl:value-of select="//owners/item"/>
                            <xsl:text>_</xsl:text>
                            <xsl:value-of select="."/>
                            <xsl:text>,</xsl:text>
                        </xsl:for-each> 
                </xsl:element>

        </xsl:element>
    </xsl:element>
</xsl:if>
<xsl:if test="not(/response/icons/item) and not(/response/owners/item)">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">photos</xsl:attribute>
        <xsl:attribute name="function">getAlbums</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$ARRAY}">
                <xsl:attribute name="name">albumList</xsl:attribute>
                <xsl:attribute name="quantity">
                    <xsl:value-of select="0"/>
                </xsl:attribute>                                
            </xsl:element>
        </xsl:element>
    </xsl:element>
</xsl:if>

</xsl:template>

</xsl:stylesheet>
