/*
 * dbus_functions.h - methods for work with webauth application
 * This file is part of libvkontakte library
 *
 * Copyright (C) 2010 - Sergey Zakharov
 *
 * libvkontakte library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libvkontakte library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libvkontakte library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */
#ifndef _DBUS_FUNCTIONS_H_
#define _DBUS_FUNCTIONS_H_

#include <dbus/dbus.h> /* Pull in all of D-Bus headers. */
#include <stdio.h>     /* printf, fprintf, stderr */
#include <stdlib.h>    /* EXIT_FAILURE, EXIT_SUCCESS */
#include <assert.h>    /* assert */
#include <glib.h>

#define SYSNOTE_NAME  "org.lomalan.AuthManager"
#define SYSNOTE_NAME2  "org.lomalan.AuthManager2"
#define SYSNOTE_OPATH "/AuthManager"
#define SYSNOTE_IFACE "org.lomalan.AuthManager"
#define SYSNOTE_NOTE_AUTH  "Auth"
#define SYSNOTE_NOTE_PROXY  "SetProxy"
#define SYSNOTE_SIGNAL  "vkontakte"
#define SYSNOTE_SIGNAL_SHUTDOWN  "shutdown"
#define SEARCH_RULE "type='signal',interface='org.lomalan.AuthManager'"
#define RESULT_NAME "authResult"
#define ACCOUNT_ID_NAME "accountID"


void terminateOnError(const char* msg, const DBusError* error);
void receive(char** url, char* client_id);
char* webauth(char* url, char* proxy, char* port, char* user, char* pass, char** expr, int elen, char* client_id);

#endif
