/*
 * parser.h -  parser for driver vkontakte of MSA program
 * This file is part of MSA program
 *
 * Copyright (C) 2009 - Sergey Zakharov
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */
#ifndef _PARSER_H_
#define _PARSER_H_

#include <stdio.h>
#include <stdlib.h>
 #include <stddef.h>
 #include <string.h>
 #include <json.h>

#include <unistd.h>
#include <libxml/encoding.h>
#include <libxml/xmlwriter.h>
#include <libxml/tree.h>

#include "driver.h"
#include "vkontakte.h"

 #define XML_ENC "utf-8"
 #define ID_KEY "id"
 #define FIRST_NAME_KEY "fn"
 #define LAST_NAME_KEY "ln"
 #define CITY_KEY "cin"
 #define CITY_ID_KEY "cii"
 #define COUNTRY_KEY "con"
 #define COUNTRY_ID_KEY "coi"
 #define MALE_KEY "sx"
 #define POL_VIEW_KEY "pv"
 #define FAMILY_KEY "fs"
 #define BIRTH_DAY_KEY "bd"
 #define BIRTH_MONTH_KEY "bm"
 #define BIRTH_YEAR_KEY "by"
 #define EDUCATION_KEY "edu"
 #define HABITATION_KEY "ht"
 #define FRIENDS_KEY "fr"
 #define IMG_KEY "bp"

//TYPES
#define TYPE_STRING "string"
#define TYPE_IMG "img"
#define TYPE_NUMBER "number"
#define TYPE_STRUCT "struct"
#define TYPE_SELECT "select"
#define TYPE_ARRAY "array"

int parser_profile(xmlDocPtr doc, char *json, char* remixmid);
int parser_image(xmlDocPtr doc, char* data, char* url);
int parser_friends(char* json, xmlDocPtr doc);
 
int parser_messages(char *json, xmlDocPtr doc);

/**
 * Parses json data, form xml
 * @param json - data in json format
 * @return number of new messages
 */
int parser_new_messages(char* json);
int check(char* json);	
#endif
