/*
 * mysociasl_driver.h - interface for module developers
 * This file is part of MySocials program
 *
 * Copyright (C) 2009, 2010 - Alexander V. Borodin
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MAS program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MAS program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#ifndef _MYSOCIALS_DRIVER_H_
#define _MYSOCIALS_DRIVER_H_

#include <glib.h>

#include <libxml/tree.h>
#include <libxml/parser.h>


#define VK_ID "vkontakte"
#define UI_ID "ui"
#define DB_ID "db"
//#define MYSPACE_ID "myspace"
#define DRV_MANAGER_ID "drv_manager"
#define HANDLER_ID "handler"
#define KERNEL_ID "kernel"
#define TEST_ID "test_module" // id test module :))  

#define TARGET_TAG "TargetID"
#define TARGET_TAG_ORDER_ATTR "orderNumber"
#define TARGET_TAG_XPATH "//TransitData/TargetID"
#define SOURCE_TAG_XPATH "//TransitData/SourceID"
#define REQUEST_TAG_XPATH "//TransitData/Content/Request"
#define RESPONSE_TAG_XPATH "//TransitData/Content/Response"
#define REQUEST_PARAMS_TAG_XPATH "//TransitData/Content/Request/Params"
#define RESPONSE_PARAMS_TAG_XPATH "//TransitData/Content/Response/Params"

//FIXME use in ui.c 
#define PARAMS_TAG_XPATH "//TransitData/Content/Response/Params/array"

#define CLASS_PROFILE "profile"
#define GET_PROFILE "getProfile"
#define GET_FRIENDS_PROFILE "getFriendsProfile"
#define SET_PROFILE "setProfile"
#define UPDATE_PROFILE "updateProfile"

#define CLASS_FRIENDS "friends"
#define GET_FRIENDS "getListFriends"
#define UPDATE_FRIENDS "updateListFriends"

#define CLASS_BOX_MESSAGE "messages"
#define UPDATE_INBOX_MESSAGES "updateInboxMessages"
#define UPDATE_OUTBOX_MESSAGES "updateOutboxMessages"
#define GET_INBOX_MESSAGES "getInboxMessages"
#define GET_OUTBOX_MESSAGES "getOutboxMessages"
#define GET_NEW_MESSAGES "getNewInboxMessages"

#define CLASS_MESSAGES "systemMessages"
#define INFO_MESSAGE "infoMessage"
#define ERROR_MESSAGE "errorMessage"

#define CLASS_BINARY_DATA "binaryData"
#define GET_BINARY_DATA "getBinaryData"

#define TARGET_NODE "TargetID"

/** Driver message code **/
#define DRV_SETT_ERROR_CODE "409"
#define DRV_SETT_SAVED_CODE "410"
#define DRV_AUTH_ERROR_CODE "407"
#define DRV_REQ_ERROR_CODE "402"
#define DRV_PROF_SAVED_CODE "400"
#define DRV_CAPT_ERROR_CODE "408"
#define DRV_RESP_ERROR_CODE "403"
#define DRV_NETW_ERROR_CODE "404"
#define DRV_MESS_SEND_CODE "401"
#define DRV_MESS_ERROR_CODE "405"
#define DRV_ACCESS_ERROR_CODE "406"
#define DRV_SERVER_ERROR_CODE "411"
#define DRV_MESS_DEL_ERROR_CODE "412"
#define DRV_MESS_DEL_CODE "413"
#define DRV_FRIEND_DEL_CODE "414"

/** Driver message text **/
#define DRV_SETT_ERROR "Unable to save settings"
#define L10N_DRV_SETT_ERROR _("Unable to save settings")

#define DRV_SETT_SAVED "Settings saved"
#define L10N_DRV_SETT_SAVED _("Settings saved")

#define DRV_AUTH_ERROR "Authorization problem"
#define L10N_DRV_AUTH_ERROR _("Authorization problem")

#define DRV_REQ_ERROR "Unable to perform request"
#define L10N_DRV_REQ_ERROR _("Unable to perform request")

#define DRV_PROF_SAVED "Profile changed"
#define L10N_DRV_PROF_SAVED _("Profile changed")

#define DRV_CAPT_ERROR "Captcha"
#define L10N_DRV_CAPT_ERROR _("Captcha")

#define DRV_RESP_ERROR "Bad response from server"
#define L10N_DRV_RESP_ERROR _("Bad response from server")

#define DRV_NETW_ERROR "Network problem"
#define L10N_DRV_NETW_ERROR _("Network problem")

#define DRV_MESS_SEND "Message send"
#define L10N_DRV_MESS_SEND _("Message send")

#define DRV_MESS_ERROR "Unable send message"
#define L10N_DRV_MESS_ERROR _("Unable send message")

#define DRV_ACCESS_ERROR "Operation prohibited by privacy"
#define L10N_DRV_ACCESS_ERROR _("Operation prohibited by privacy")

#define DRV_SERVER_ERROR "Internal Server Error"
#define L10N_DRV_SERVER_ERROR _("Internal Server Error")

#define DRV_MESS_DEL_ERROR "Can't delete message"
#define L10N_DRV_MESS_DEL_ERROR _("Can't delete message")

#define DRV_MESS_DEL "Message deleted"
#define L10N_DRV_MESS_DEL _("Message deleted")

#define DRV_FRIEND_DEL "Friend deleted"
#define L10N_DRV_FRIEND_DEL _("Friend deleted")

/* Entity names */
#define FIRST_NAME "FirstName"
#define L10N_FIRST_NAME _("FirstName")

#define LAST_NAME "LastName"
#define L10N_LAST_NAME _("LastName")

#define CITY_NAME "CityName"
#define L10N_CITY_NAME _("CityName")

#define COUNTRY_NAME "CountryName"
#define L10N_COUNTRY_NAME _("CountryName")

#define BIRTHDAY_NAME "Birthday"
#define L10N_BIRTHDAY_NAME _("Birthday")

#define GENDER_NAME "Gender"
#define L10N_GENDER_NAME _("Gender")

#define FAMILY_STATE_NAME "FamilyState"
#define L10N_FAMILY_STATE_NAME _("FamilyState")

#define POLITICAL_VIEW_NAME "PoliticalView"
#define L10N_POLITICAL_VIEW_NAME _("PoliticalView")

/* Entity values */
#define MALE "male"
#define L10N_MALE _("male")

#define FEMALE "female"
#define L10N_FEMALE _("female")

#define NO_MALE "none"
#define L10N_NO_MALE _("none")

#define FAMILY_STATE_1 "single"
#define L10N_FAMILY_STATE_1 _("single")

#define FAMILY_STATE_2 "in a relationship"
#define L10N_FAMILY_STATE_2 _("in a relationship")

#define FAMILY_STATE_3 "engaged"
#define L10N_FAMILY_STATE_3 _("engaged")

#define FAMILY_STATE_4 "married"
#define L10N_FAMILY_STATE_4 _("married")

#define FAMILY_STATE_5 "it is complicated"
#define L10N_FAMILY_STATE_5 _("it is complicated")

#define FAMILY_STATE_6 "actively searching"
#define L10N_FAMILY_STATE_6 _("actively searching")

#define FAMILY_STATE_0 "none"
#define L10N_FAMILY_STATE_0 _("none")

#define POL_VIEW_1 "Communist"
#define L10N_POL_VIEW_1 _("Communist")

#define POL_VIEW_2 "Socialist"
#define L10N_POL_VIEW_2 _("Socialist")

#define POL_VIEW_3 "Moderate"
#define L10N_POL_VIEW_3 _("Moderate")

#define POL_VIEW_4 "Liberal"
#define L10N_POL_VIEW_4 _("Liberal")

#define POL_VIEW_5 "Conservative"
#define L10N_POL_VIEW_5 _("Conservative")

#define POL_VIEW_6 "Monarchist"
#define L10N_POL_VIEW_6 _("Monarchist")

#define POL_VIEW_7 "Ultraconservative"
#define L10N_POL_VIEW_7 _("Ultraconservative")

#define POL_VIEW_8 "Apathetic"
#define L10N_POL_VIEW_8 _("Apathetic")

#define POL_VIEW_0 "none"
#define L10N_POL_VIEW_0 _("none")


#ifndef _MSA_MODULE
#define _MSA_MODULE

/* Error Code */
typedef enum error_type
{
    FAILURE = -1,
    NO_ERRORS = 0,
    SUCCESS = 0,
    ERROR_ALLOCATION_OF_MEMORY,
    ERROR_NO_DRIVER_FUNCTION,
    ERROR_INITIALIZATION_ALREADY_PASSED,
    ERROR_DRIVER_IS_BUSY,
    ERROR_CANT_SEND_DATA,
    ERROR_CANT_PARSE_DATA
} error_type;

/** @enum msa_module_type
 *  @brief List of module types
 *
 *  Currently there are three module types:
 *    UI for user interface modules
 *    SYSTEM for system modules (kernel)
 *    DRIVER for network services connectivity modules
 */
typedef enum _msa_module_type {
    MODULE,
    DRIVER,
    SYSTEM,
    TEST_MODULE
} msa_module_type;

/** @enum status
 *  @brief List of module status
 *
 *  Currently there are two module status:
 *    ON module on
 *    OFF module off
 *    BROKEN module have fatal error!
 */

typedef enum _msa_module_status {
	OFF = 0,
    ON = 1,
    BROKEN = 2,
    BUSY = 3,
	NOT_CON = 4   

} msa_module_status;


/** @enum state
 *  @brief List of status
 *
 *  Currently there are two module status:
 *    ON module on
 *    OFF module off
 */

typedef enum _msa_module_state {
    CONF = 1,
    NOT_CONF = 0
} msa_module_state;

/** @struct msa_module
 *  @brief Id info and interface functions for external modules
 *
 *  Each module should implement function named
 *  int init_module(msa_module *mod)
 *  which fills in the fields of this structure and link
 *  appropriate functions to function pointers
 *  @see msa_module_type
 */
typedef struct _msa_module {
    msa_module_type type;     /** Module type of msa_module_type enum */
    gchar* id;                /** Module id, a null-terminated string*/
    gchar* name;              /** Module name for UI purposes */
    msa_module_status status; /** Module status 0 - not active  **/
    msa_module_status state;  /** Module state 0 - OK Conf 1 - not conf**/
    gchar* pic;               /** Module icon for UI purposes */
    gchar* proxy;
    gint port;

    /** Receives transmitted data to the module
     *
     *  @param data Data in XML, encoded in UTF-8
     *  @param info - information about proxy and port
     *  @return Error code for data transfer operatio
     *  @retval 0 data transfer succeeded
     */
    int (*send)(xmlDocPtr request, xmlDocPtr* response, struct _msa_module* info);

    /** UI start
     *
     *  @param msa_module struct for kernel
     *  @param list_drv GList struct with drivers
     *  @return Error code for data transfer operation
     *  @retval 0 module start succesed
     */
    int (*module_start)(gpointer kernel, gpointer list_drv, int argc, char* argv[]);


    /** Setup new module settings
     *
     *  @param id modules
     *  @param settings in struct msa_driver_info
     *  @return Error code for data transfer operation
     *  @retval 0 data transfer succeeded
     */
    int (*msa_settings)(xmlChar* info, xmlDocPtr request);


     /** Put data with events in hanler 
     *
     *  @param events data in XML, encoded in UTF-8
     *  @return Error code for data transfer operation
     *  @retval 0 data transfer succeeded
     */
    int (*set_events)(xmlChar* data);

    int (*shutdown)();

} msa_module;
#endif /*_MSA_MODULE*/

#endif
