/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Contact: Marius Vollmer <marius.vollmer@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef THUMBTEST_H
#define THUMBTEST_H

#include <QObject>
#include <QString>
#include <QTest>

#include "../../src/include/Thumbnailer"
#include "../../src/thumbnailer_p.h"
#include "../../src/include/MediaArtInfo"
#include "../../src/include/MediaArtRequester"

#define myDebug() qDebug()
#define FUNC_STARTED static unsigned __count = 0; myDebug() << " started for the" << ++__count << "time."
#define FUNC_STOPPED myDebug() << " has stopped its" << __count-- << "execution."
#define FUNC_CALLED  FUNC_STARTED; FUNC_STOPPED

using namespace MediaArt;
using namespace Thumbnails;

class ThumbTest : public QObject, public Info
{
Q_OBJECT
public:
	ThumbTest() : QObject() {}
	~ThumbTest() {}
// particular tests
private Q_SLOTS:
	void initTestCase();
	/*
	   the naming scheme is: testedFunctionName_whatWeAreTesting[_data]
	   so if You want to test if after calling function request thumbnail signal is send
	   You can create slot with name: request_checkingThumbnailSignal()
	   The second part of the name should be self-explanatory (it should be easy to understand
	   what is tested in that function)

	   _data versions of slots are connected with QTestLib architecture, see:
	   http://doc.trolltech.com/4.5/qtestlib-manual.html and
	   http://doc.trolltech.com/4.5/qtest.html for more details.
	 */
	void emptyTest_checkIfQTestLibIsWorking();

	void Thumbnailer_getThumbnailPath_direct_data();
	void Thumbnailer_getThumbnailPath_direct();

	void Thumbnailer_objectCreation();
	void Thumbnailer_objectCreation_new();
	void Thumbnailer_objectDestruction();
	void Thumbnailer_objectCreation_defaultUrl();
	void Thumbnailer_objectCreation_defaultParameters();

	void setDefaultPixmap_setting();
	void defaultPixmap_getting();
	void setDefaultURI_setting();
	void defaultURI_getting();


	void MediaArt_basicStaticType();
	void MediaArt_basicConstructor();
	void MediaArt_basicGettingDefaultType();
	void MediaArt_basicGettingType();
	/*******************************************
	  all target md5 sums calculation done via http://md5online.110mb.com/
	  ******************************************/
	void MediaArt_basicCalculatingPath_data();
	void MediaArt_basicCalculatingPath();
	/*******************************************
	  check http://live.gnome.org/MediaArtStorageSpec for info about what should be removed
	  ******************************************/
	void MediaArt_basicStrippingOutInvalidEntities_data();
	void MediaArt_basicStrippingOutInvalidEntities();
	void MediaArt_basicEqualOperator_data();
	void MediaArt_basicEqualOperator();
	void MediaArt_basicCooperationWithQHash();
	void MediaArt_basicCooperationWithQList();
	void MediaArt_basicSettingContentPath();
	void MediaArt_basicSettingContentPath_wrongSchema();
	void MediaArt_basicSettingContentPath_wrongExtension();
	void MediaArt_basicSettingContentPath_overwrite();
	void MediaArt_basicSettingContentPixmap();
	void MediaArt_basicSettingContentPixmap_overwrite();
	void MediaArt_basicRemoveingContent();

	void MediaArt_albumConstructor();
	void MediaArt_albumConstructorBasicCasting();
	void MediaArt_albumStaticType();
	void MediaArt_albumGettingAlbum();
	void MediaArt_albumGettingArtist();
	void MediaArt_albumGettingType();
	void MediaArt_albumCalculatingPotentialPath();

	void MediaArt_artistConstructor();
	void MediaArt_artistStaticType();
	void MediaArt_artistGettingArtist();
	void MediaArt_artistGettingAlbum();
	void MediaArt_artistGettingType();
	void MediaArt_artistCalculatingPotentialPath();

	void MediaArt_trackCalculatingPotentialPath();

	void MediaArt_requesterSimpleRequestOneExistingMediaArt();
	void MediaArt_requesterSimpleRequestOneNonExistingMediaArt();
	void MediaArt_requesterSimpleRequestCoupleMixedMediaArt();
};

#endif // THUMBTEST_H
