/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Contact: Marius Vollmer <marius.vollmer@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef THUMBTEST_H
#define THUMBTEST_H

#include <QObject>
#include <QString>
#include <QTest>

#include "../../src/include/Thumbnailer"
#include "../../src/include/MediaArtInfo"
#include "../../src/include/MediaArtRequester"
#include "../../src/thumbnailer_p.h"

using namespace MediaArt;
using namespace Thumbnails;

#define myDebug() qDebug()
#define FUNC_STARTED static unsigned __count = 0; myDebug() << " started for the" << ++__count << "time."
#define FUNC_STOPPED myDebug() << " has stopped its" << __count-- << "execution."
#define FUNC_CALLED  FUNC_STARTED; FUNC_STOPPED

class ThumbTest : public QObject
{
Q_OBJECT
private:
	Thumbnailer *thumbnailer;
	QString lastThumbnail;

	void setModificationTime(uint time = 0, QString file = QString());
	void createThumbnailForURI(QString uri = QString());
	void breakThumbnailForURI(QString uri = QString());
	void deleteThumbnailForURI(QString uri = QString());
	void deleteAllThumbnails();
        void createThumbnailWithTumbler(QList<QUrl>& images, QStringList& mimes);

private slots:
	void initTestCase();
	void cleanupTestCase();
	void init();
	void cleanup();

// particular tests
private Q_SLOTS:
	/*
	   the naming scheme is: testedFunctionName_whatWeAreTesting[_data]
	   so if You want to test if after calling function request thumbnail signal is send
	   You can create slot with name: request_checkingThumbnailSignal()
	   The second part of the name should be self-explanatory (it should be easy to understand
	   what is tested in that function)

	   _data versions of slots are connected with QTestLib architecture, see:
	   http://doc.trolltech.com/4.5/qtestlib-manual.html and
	   http://doc.trolltech.com/4.5/qtest.html for more details.
	 */
	void getSchedulers();
	void getSchedulers_checkingFirstItem();
	void getSchedulers_nonEmptyItems();
	void getSchedulers_noopItem();
	void getFlavors();
	void getFlavors_normalExists();
	void getFlavors_nonEmptyItems();
	void getFlavorSize();
	void getFlavorSize_nonExisting();
	void getSupported();
	void getSupported_nonEmptySchemes();

	void getThumbnailPath_data();
	void getThumbnailPath();

        void move_request();
        void copy_request();
        void remove_request();


	//void cleanup_data();
	//void cleanup();

	//void setDefaultURI_data();
	//void setDefaultURI();
	//void setDefaultPixmap_data();
	//void setDefaultPixmap();
	//void getDefaultURI_data();
	//void getDefaultURI();
	//void getDefaultPixmap_data();
	//void getDefaultPixmap();

	void request_oneNonExistingThumbnail_emptyCache_bug146404();
	void request_oneNonPossibleThumbnail_emptyCache_bug146404();
	void request_oneNonExistingThumbnail();
	void request_oneVideoFile();
	void request_oneExistingThumbnail();
	void request_noopScheduler();
	void request_oneNonExistingThumbnailForBrokenFile();

	//void request_allSchedulers_data();
	//void request_allSchedulers();
	//void request_allFlavors_data();
	//void request_allFlavors();
	//void request_allSchedulersFlavorsCombinations_data();
	//void request_allSchedulersFlavorsCombinations();

	// tests connected with bugs
	void bug_125965_twoRequestWithError_data();
	void bug_125965_twoRequestWithError();
	void bug_125965_twoRequestWithError_noWait_data();
	void bug_125965_twoRequestWithError_noWait();

	void bug_143261_multipleRequests();
	void bug_163333_thumbnailerCrashAfterDelete();

	/****************************
		MEDIA ARTS
	 ***************************/
	void request_oneExistingThumbnailMediaArt();
	void request_oneNonExistingThumbnailMediaArt();
	void request_oneNonExistingThumbnailNonExistingMediaArt();
	void request_coupleMixedThumbnailsOfMixedMediaArts();
};

#endif // THUMBTEST_H

