#####################################################################
# Main projectfile
#####################################################################

CONFIG += ordered 
TEMPLATE = subdirs

include (shared.pri)

!contains(DEFINES, BUILD_LIBRARY) {
    LIBRARY_INC_DIR = $${LIBRARY_BASE_DIR}/src
                          
    LIBRARY_LIB_DIR = $${LIBRARY_BASE_DIR}/lib

    INCLUDEPATH += $${LIBRARY_INC_DIR}
    DEPENDPATH += $${LIBRARY_INC_DIR}

    unix: QMAKE_LFLAGS += $${QMAKE_LFLAGS_RPATH}$${LIBRARY_LIB_DIR}
    LIBS += -L$${LIBRARY_LIB_DIR}
    qtAddLibrary($${LIBRARYNAME_LC})
}

QT += core dbus

isEmpty(LIBRARY_BUILD_PARTS) { #defaults
  LIBRARY_BUILD_PARTS = libs doc
} else { #make sure the order makes sense
   contains(LIBRARY_BUILD_PARTS, doc) {
       LIBRARY_BUILD_PARTS -= doc
       LIBRARY_BUILD_PARTS = doc $$LIBRARY_BUILD_PARTS
   }
   contains(LIBRARY_BUILD_PARTS, libs) {
       LIBRARY_BUILD_PARTS -= libs
       LIBRARY_BUILD_PARTS = libs $$LIBRARY_BUILD_PARTS
   }
}

#process the projects
for(PROJECT, $$list($$lower($$unique(LIBRARY_BUILD_PARTS)))) {
    isEqual(PROJECT, libs) {
       SUBDIRS += src tests
    } else:isEqual(PROJECT, doc) {
       include(doc/doc.pri)
    } else {
       message(Unknown PROJECT: $$PROJECT)
    }
}

setup.commands = install -d $$quote(\"$(INSTALL_ROOT)$$[QT_INSTALL_DATA]/mkspecs/features\") && echo \"LIBRARY_BASE_DIR = $$PWD\" > $$quote(\"$(INSTALL_ROOT)$$[QT_INSTALL_DATA]/mkspecs/features/$${LIBRARYNAME_LC}_install.prf\")
#setup.commands += && $(COPY_FILE) $${LIBRARYNAME_LC}.prf $$quote(\"$$[QT_INSTALL_DATA]/mkspecs/features\")
QMAKE_EXTRA_TARGETS += setup

QMAKE_CLEAN += lib/lib$${LIBRARYNAME_LC}* build-stamp configure-stamp artifacts/*.deb doc/reference/* doc/man/*
QMAKE_DISTCLEAN += lib/lib$${LIBRARYNAME_LC}* build-stamp configure-stamp artifacts/*.deb doc/reference/* doc/man/* 

install.commands += make setup
QMAKE_EXTRA_TARGETS += install

# add 'make check' target
check.CONFIG = recursive
check.recurse = src tests
check.depends = install
QMAKE_EXTRA_TARGETS += check

# make sure we add proper flags for compiler if coverage was added (CONFIG+=coverage)
if(coverage) {
	coverage-report.CONFIG = recursive
	coverage-report.recurse = src
	QMAKE_EXTRA_TARGETS += coverage-report
	message('******************************************************************' )
	message('* Remember to disable CCACHE in scratchbox to make Code Coverage' )
	message('* report!' )
	message('* use command: export SBOX_USE_CCACHE="no"' )
	message('******************************************************************' )
}
