/*
 * tangle-stretch-action.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_STRETCH_ACTION_H__
#define __TANGLE_STRETCH_ACTION_H__

#include <clutter/clutter.h>

#define TANGLE_TYPE_STRETCH_ACTION (tangle_stretch_action_get_type())
#define TANGLE_STRETCH_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_STRETCH_ACTION, TangleStretchAction))
#define TANGLE_IS_STRETCH_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_STRETCH_ACTION))
#define TANGLE_STRETCH_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_STRETCH_ACTION, TangleStretchActionClass))
#define TANGLE_IS_STRETCH_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_STRETCH_ACTION))
#define TANGLE_STRETCH_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_STRETCH_ACTION, TangleStretchActionClass))

typedef struct _TangleStretchActionPrivate TangleStretchActionPrivate;

typedef struct _TangleStretchAction {
	ClutterDragAction parent_instance;
	TangleStretchActionPrivate* priv;
} TangleStretchAction;

typedef struct _TangleStretchActionClass {
	ClutterDragActionClass parent_class;
} TangleStretchActionClass;

GType tangle_stretch_action_get_type(void) G_GNUC_CONST;

ClutterAction* tangle_stretch_action_new(ClutterActor* stretched_actor);

ClutterActor* tangle_stretch_action_get_stretched_actor(TangleStretchAction* stretch_action);
void tangle_stretch_action_set_stretched_actor(TangleStretchAction* stretch_action, ClutterActor* stretched_actor);

void tangle_stretch_action_get_min_size(TangleStretchAction* stretch_action, gfloat* min_width_return, gfloat* min_height_return);
void tangle_stretch_action_set_min_size(TangleStretchAction* stretch_action, gfloat min_width, gfloat min_height);
void tangle_stretch_action_get_max_size(TangleStretchAction* stretch_action, gfloat* max_width_return, gfloat* max_height_return);
void tangle_stretch_action_set_max_size(TangleStretchAction* stretch_action, gfloat max_width, gfloat max_height);

#endif
