#include <tangle/tangle.h>

static void on_pressed_notify(GObject* object, GParamSpec* param_spec, gpointer user_data) {
	TangleHoldAction* hold_action;
	
	hold_action = TANGLE_HOLD_ACTION(user_data);
	
	g_print("Pressed: %s\n", tangle_hold_action_get_pressed(hold_action) ? "true" : "false");
}

static void on_held() {
	g_print("Held!\n");
}

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* actor;
	ClutterAction* action;
	
	tangle_init(&argc, &argv);
	stage = clutter_stage_get_default();
	clutter_actor_set_size(stage, 800.0, 400.0);

	actor = clutter_texture_new_from_file("test_image_100x74.jpg", NULL);
	clutter_actor_set_reactive(actor, TRUE);
	
	action = tangle_hold_action_new();
	g_signal_connect(action, "notify::pressed", G_CALLBACK(on_pressed_notify), action);
	g_signal_connect(action, "held", G_CALLBACK(on_held), action);
	clutter_actor_add_action(actor, action);
	
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), actor);
	
	clutter_actor_show_all(stage);	
	clutter_main();

	return 0;
}
