/*
 * tangle-stack-layout.c
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#include "tangle-stack-layout.h"

/**
 * SECTION:tangle-stack-layout
 * @Short_description: 	A layout manager that arranges children into a stack
 * @Title: TangleStackLayout
 */

G_DEFINE_TYPE(TangleStackLayout, tangle_stack_layout, TANGLE_TYPE_LAYOUT);

TangleLayout* tangle_stack_layout_new() {

	return TANGLE_LAYOUT(g_object_new(TANGLE_TYPE_STACK_LAYOUT, NULL));
}

static void tangle_stack_layout_get_preferred_width(TangleLayout* layout, TangleWidget* widget, gfloat for_height, gfloat* min_width_p, gfloat* natural_width_p) {
	gfloat max_min_width;
	gfloat max_natural_width;
	GList* child_in_list;
	ClutterActor* actor;
	gfloat actor_min_width;
	gfloat actor_natural_width;

	max_min_width = 0.0;
	max_natural_width = 0.0;
	for (child_in_list = tangle_widget_get_children_readonly(widget); child_in_list; child_in_list = child_in_list->next) {
		actor = CLUTTER_ACTOR(child_in_list->data);
		if (CLUTTER_ACTOR_IS_VISIBLE(actor)) {
			tangle_layout_get_preferred_actor_width(layout, actor, for_height, &actor_min_width, &actor_natural_width);
			if (actor_min_width > max_min_width) {
				max_min_width = actor_min_width;
			}
			if (actor_natural_width > max_natural_width) {
				max_natural_width = actor_natural_width;
			}
		}
	}
	if (min_width_p) {
		*min_width_p = max_min_width;
	}
	if (natural_width_p) {
		*natural_width_p = max_natural_width;
	}
}

static void tangle_stack_layout_get_preferred_height(TangleLayout* layout, TangleWidget* widget, gfloat for_width, gfloat* min_height_p, gfloat* natural_height_p) {
	gfloat max_min_height;
	gfloat max_natural_height;
	GList* child_in_list;
	ClutterActor* actor;
	gfloat actor_min_height;
	gfloat actor_natural_height;

	max_min_height = 0.0;
	max_natural_height = 0.0;
	for (child_in_list = tangle_widget_get_children_readonly(widget); child_in_list; child_in_list = child_in_list->next) {
		actor = CLUTTER_ACTOR(child_in_list->data);
		if (CLUTTER_ACTOR_IS_VISIBLE(actor)) {
			tangle_layout_get_preferred_actor_height(layout, actor, for_width, &actor_min_height, &actor_natural_height);
			if (actor_min_height > max_min_height) {
				max_min_height = actor_min_height;
			}
			if (actor_natural_height > max_natural_height) {
				max_natural_height = actor_natural_height;
			}
		}
	}
	if (min_height_p) {
		*min_height_p = max_min_height;
	}
	if (natural_height_p) {
		*natural_height_p = max_natural_height;
	}
}

static void tangle_stack_layout_allocate(TangleLayout* layout, TangleWidget* widget, gfloat width, gfloat height, ClutterAllocationFlags flags) {
	ClutterActorBox actor_box;
	GList* child_in_list;
	ClutterActor* actor;

	actor_box.x1 = 0.0;
	actor_box.y1 = 0.0;
	actor_box.x2 = width;
	actor_box.y2 = height;
	for (child_in_list = tangle_widget_get_children_readonly(widget); child_in_list; child_in_list = child_in_list->next) {
		actor = CLUTTER_ACTOR(child_in_list->data);
		if (CLUTTER_ACTOR_IS_VISIBLE(actor)) {
			tangle_layout_allocate_actor(layout, actor, &actor_box, flags);
		}
	}
}

static void tangle_stack_layout_class_init(TangleStackLayoutClass* stack_layout_class) {
	GObjectClass* gobject_class = G_OBJECT_CLASS(stack_layout_class);
	TangleLayoutClass* layout_class = TANGLE_LAYOUT_CLASS(stack_layout_class);

	layout_class->get_preferred_width = tangle_stack_layout_get_preferred_width;
	layout_class->get_preferred_height = tangle_stack_layout_get_preferred_height;
	layout_class->allocate = tangle_stack_layout_allocate;
}

static void tangle_stack_layout_init(TangleStackLayout* stack_layout) {
}

