/*
 * tangle-properties.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_PROPERTIES_H__
#define __TANGLE_PROPERTIES_H__

#include <glib-object.h>
#include "tangle-object.h"

#define TANGLE_TYPE_PROPERTIES (tangle_properties_get_type())
#define TANGLE_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_PROPERTIES, TangleProperties))
#define TANGLE_IS_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_PROPERTIES))
#define TANGLE_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_PROPERTIES, TanglePropertiesClass))
#define TANGLE_IS_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_PROPERTIES))
#define TANGLE_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_PROPERTIES, TanglePropertiesClass))

typedef struct _TanglePropertiesPrivate TanglePropertiesPrivate;

typedef struct _TangleProperties {
	TangleObject parent_instance;
	TanglePropertiesPrivate* priv;
} TangleProperties;

typedef struct _TanglePropertiesClass {
	TangleObjectClass parent_class;
	
	gboolean (*validate_property)(TangleProperties* properties, const gchar* name, const GValue* value);
} TanglePropertiesClass;

typedef void (*TanglePropertyCallback)(const gchar* name, const GValue* value, gpointer user_data);
#define TANGLE_PROPERTY_CALLBACK(f) ((TanglePropertyCallback)(f))

GType tangle_properties_get_type(void) G_GNUC_CONST;

TangleProperties* tangle_properties_new(void);

GType tangle_properties_get_property_type(TangleProperties* properties, const gchar* name);
gboolean tangle_properties_get_property(TangleProperties* properties, const gchar* name, GValue* value);
gboolean tangle_properties_get(TangleProperties* properties, const gchar* first_name, GType first_type, ...);
gboolean tangle_properties_get_boolean(TangleProperties* properties, const gchar* name);
gint64 tangle_properties_get_int(TangleProperties* properties, const gchar* name);
double tangle_properties_get_double(TangleProperties* properties, const gchar* name);
const gchar* tangle_properties_get_string(TangleProperties* properties, const gchar* name);
gchar* tangle_properties_dup_string(TangleProperties* properties, const gchar* name);
GParameter* tangle_properties_get_as_parameters(TangleProperties* properties, guint* n_p);
void tangle_properties_set_property(TangleProperties* properties, const gchar* name, const GValue* value);
void tangle_properties_set(TangleProperties* properties, ...);
void tangle_properties_set_valist(TangleProperties* properties, va_list properties_list);
void tangle_properties_set_boolean(TangleProperties* properties, const gchar* name, gboolean boolean_value);
void tangle_properties_set_int(TangleProperties* properties, const gchar* name, gint64 int_value);
void tangle_properties_set_double(TangleProperties* properties, const gchar* name, double double_value);
void tangle_properties_set_string(TangleProperties* properties, const gchar* name, const gchar* string_value);
void tangle_properties_foreach(TangleProperties* properties, TanglePropertyCallback callback, gpointer user_data);

#endif
