#include <clutter/clutter.h>
#include <tangle/tangle.h>

gboolean on_button1_clicked(TangleButton* button, gpointer user_data) {
	g_printf("Button 1 clicked.\n");

	return FALSE;
}

gboolean on_button2_clicked(TangleButton* button, gpointer user_data) {
	g_printf("Button 2 clicked.\n");

	return FALSE;
}

gboolean on_clicked(TangleButton* button, gpointer user_data) {
	TangleButton* other_button;
	
	other_button = TANGLE_BUTTON(user_data);
	
	g_printf("%s clicked (signal connected by %s).\n", clutter_get_script_id(G_OBJECT(other_button)), clutter_get_script_id(G_OBJECT(button)));

	return FALSE;
}

void on_notify(GObject* object, GParamSpec* param_spec, gpointer user_data) {
	g_printf("Notify: %s\n", g_param_spec_get_name(param_spec));
}

int main(int argc, char** argv) {
	ClutterActor* stage;
	const gchar* filename;
	GError* error = NULL;
	ClutterScript* script;
	ClutterActor* actor;
	
	tangle_init(&argc, &argv);
	
	stage = clutter_stage_get_default();
	g_object_set(G_OBJECT(stage), "width", 800.0, "height", 480.0, NULL);

	if (argc > 1) {
		filename = argv[1];
	} else {
		filename = "test-script.json";
	}

	script = clutter_script_new();
	if (!clutter_script_load_from_file(script, filename, &error)) {
		g_critical("Error when loading '%s': %s", filename, error->message);
	} else if (!(actor = CLUTTER_ACTOR(clutter_script_get_object(script, "main")))) {
		g_critical("Could not find an object named 'main' from '%s'.", filename);
	} else {
		clutter_container_add_actor(CLUTTER_CONTAINER(stage), actor);
	}

	clutter_actor_show(stage);
	
	clutter_main();
	
	return 0;
}
