/*
 * tangle-button-group.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_BUTTON_GROUP_H__
#define __TANGLE_BUTTON_GROUP_H__

#include "tangle-button.h"

#define TANGLE_TYPE_BUTTON_GROUP (tangle_button_group_get_type())
#define TANGLE_BUTTON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_BUTTON_GROUP, TangleButtonGroup))
#define TANGLE_IS_BUTTON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_BUTTON_GROUP))
#define TANGLE_BUTTON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_BUTTON_GROUP, TangleButtonGroupClass))
#define TANGLE_IS_BUTTON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_BUTTON_GROUP))
#define TANGLE_BUTTON_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_BUTTON_GROUP, TangleButtonGroupClass))

typedef struct _TangleButtonGroupPrivate TangleButtonGroupPrivate;

typedef struct _TangleButtonGroup {
	GObject parent_instance;
	TangleButtonGroupPrivate* priv;
} TangleButtonGroup;

typedef struct _TangleButtonGroupClass {
	GObjectClass parent_class;
} TangleButtonGroupClass;

GType tangle_button_group_get_type(void) G_GNUC_CONST;

TangleButtonGroup* tangle_button_group_new(void);
TangleButtonGroup* tangle_button_group_new_with_buttons(TangleButton* first_button, ...);

void tangle_button_group_create(TangleButton* first_button, ...);

void tangle_button_group_add_button(TangleButtonGroup* button_group, TangleButton* button);
void tangle_button_group_remove_button(TangleButtonGroup* button_group, TangleButton* button);
GList* tangle_button_group_get_buttons(TangleButtonGroup* button_group);

TangleButton* tangle_button_group_get_selected_button(TangleButtonGroup* button_group);

#endif
