/*
 * tangle-apply-template-action.h
 *
 * This file is part of Tangle Toolkit - A graphical actor library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_APPLY_TEMPLATE_ACTION_H__
#define __TANGLE_APPLY_TEMPLATE_ACTION_H__

#include "tangle-action.h"
#include "tangle-template.h"

#define TANGLE_TYPE_APPLY_TEMPLATE_ACTION (tangle_apply_template_action_get_type())
#define TANGLE_APPLY_TEMPLATE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_APPLY_TEMPLATE_ACTION, TangleApplyTemplateAction))
#define TANGLE_IS_APPLY_TEMPLATE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_APPLY_TEMPLATE_ACTION))
#define TANGLE_APPLY_TEMPLATE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_APPLY_TEMPLATE_ACTION, TangleApplyTemplateActionClass))
#define TANGLE_IS_APPLY_TEMPLATE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_APPLY_TEMPLATE_ACTION))
#define TANGLE_APPLY_TEMPLATE_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_APPLY_TEMPLATE_ACTION, TangleApplyTemplateActionClass))

typedef struct _TangleApplyTemplateActionPrivate TangleApplyTemplateActionPrivate;

typedef struct _TangleApplyTemplateAction {
	TangleAction parent_instance;
	TangleApplyTemplateActionPrivate* priv;
} TangleApplyTemplateAction;

typedef struct _TangleApplyTemplateActionClass {
	TangleActionClass parent_class;
} TangleApplyTemplateActionClass;

GType tangle_apply_template_action_get_type(void) G_GNUC_CONST;

TangleAction* tangle_apply_template_action_new(TangleTemplate* template, GObject* object);

TangleTemplate* tangle_apply_template_action_get_template(TangleApplyTemplateAction* action);
void tangle_apply_template_action_set_template(TangleApplyTemplateAction* action, TangleTemplate* template);
GObject* tangle_apply_template_action_get_object(TangleApplyTemplateAction* action);
void tangle_apply_template_action_set_object(TangleApplyTemplateAction* action, GObject* object);

#endif
