/*
 * tangle-object.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_OBJECT_H__
#define __TANGLE_OBJECT_H__

#include <clutter/clutter.h>

#define TANGLE_TYPE_OBJECT (tangle_object_get_type())
#define TANGLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_OBJECT, TangleObject))
#define TANGLE_IS_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_OBJECT))
#define TANGLE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_OBJECT, TangleObjectClass))
#define TANGLE_IS_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_OBJECT))
#define TANGLE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_OBJECT, TangleObjectClass))

typedef struct _TangleObjectPrivate TangleObjectPrivate;

typedef struct _TangleObject {
	GObject parent_instance;
	TangleObjectPrivate* priv;
} TangleObject;

typedef struct _TangleObjectClass {
	GObjectClass parent_class;
} TangleObjectClass;

GType tangle_object_get_type(void) G_GNUC_CONST;

gchar* tangle_object_lookup_filename(TangleObject* object, const gchar* filename);
ClutterScript* tangle_object_get_script(TangleObject* object);
void _tangle_object_set_script(TangleObject* object, ClutterScript* script);

#endif
