/*
 * tangle-layout-meta.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_LAYOUT_META_H__
#define __TANGLE_LAYOUT_META_H__

#include <glib-object.h>

#define TANGLE_TYPE_LAYOUT_META (tangle_layout_meta_get_type())
#define TANGLE_LAYOUT_META(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_LAYOUT_META, TangleLayoutMeta))
#define TANGLE_IS_LAYOUT_META(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_LAYOUT_META))
#define TANGLE_LAYOUT_META_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_LAYOUT_META, TangleLayoutMetaClass))
#define TANGLE_IS_LAYOUT_META_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_LAYOUT_META))
#define TANGLE_LAYOUT_META_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_LAYOUT_META, TangleLayoutMetaClass))

typedef struct _TangleLayoutMetaPrivate TangleLayoutMetaPrivate;

typedef struct _TangleLayoutMeta {
	GObject parent_instance;
	TangleLayoutMetaPrivate* priv;
} TangleLayoutMeta;

typedef struct _TangleLayoutMetaClass {
	GObjectClass parent_class;
} TangleLayoutMetaClass;

GType tangle_layout_meta_get_type(void) G_GNUC_CONST;

#include "tangle-layout.h"

TangleLayout* tangle_layout_meta_get_layout(TangleLayoutMeta* layout_meta);
ClutterActor* tangle_layout_meta_get_actor(TangleLayoutMeta* layout_meta);

#endif

