/*
 * tangle-binding.h
 *
 * This file is part of Tangle Toolkit - A graphical actor library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */
 
#ifndef __TANGLE_BINDING_H__
#define __TANGLE_BINDING_H__

#include <glib-object.h>

#define TANGLE_TYPE_BINDING (tangle_binding_get_type())
#define TANGLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_BINDING, TangleBinding))
#define TANGLE_IS_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_BINDING))
#define TANGLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_BINDING, TangleBindingClass))
#define TANGLE_IS_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_BINDING))
#define TANGLE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_BINDING, TangleBindingClass))

typedef struct _TangleBindingPrivate TangleBindingPrivate;
typedef struct _TangleBinding TangleBinding;
typedef struct _TangleBindingClass TangleBindingClass;
typedef enum _TangleBindingDirection TangleBindingDirection;

typedef void (*TangleBindingCallback)(GObject* object, const gchar* property, gpointer user_data);

struct _TangleBinding {
	GObject parent_instance;
	TangleBindingPrivate* priv;
};

struct _TangleBindingClass {
	GObjectClass parent_class;
};

enum _TangleBindingDirection {
	TANGLE_BINDING_NONE = 0,
	TANGLE_BINDING_A_TO_B = 1,
	TANGLE_BINDING_B_TO_A = 2,
	TANGLE_BINDING_BIDIRECTIONAL = 3
};

GType tangle_binding_get_type(void) G_GNUC_CONST;

TangleBinding* tangle_binding_new(GObject* object_a, const gchar* property_a, GObject* object_b, const gchar* property_b);

GObject* tangle_binding_get_object_a(TangleBinding* binding);
const gchar* tangle_binding_get_property_a(TangleBinding* binding);
GObject* tangle_binding_get_object_b(TangleBinding* binding);
const gchar* tangle_binding_get_property_b(TangleBinding* binding);
TangleBindingDirection tangle_binding_get_direction(TangleBinding* binding);
GList* tangle_object_get_bindings_readonly(GObject* object, const gchar* property);

#endif
