#include <tangle/tangle.h>

gboolean on_button_clicked(TangleButton* button) {
	g_print("Clicked\n");
	
	return FALSE;
}

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* container;
	ClutterActor* clutter_actor;
	ClutterActor* draggable_actor;
	ClutterActor* droppable_actor;
	
	tangle_init(&argc, &argv);
	stage = clutter_stage_get_default();
	
	container = tangle_widget_new();
	clutter_actor_set_position(container, 100.0, 100.0);
	tangle_widget_set_layout(TANGLE_WIDGET(container), tangle_box_layout_new());
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), container);
	
	clutter_actor = tangle_button_new_with_background_actors(
	 clutter_texture_new_from_file("test_image_100x74.jpg", NULL),
	 clutter_texture_new_from_file("test_image_selected_100x74.jpg", NULL));
	g_signal_connect(clutter_actor, "clicked", G_CALLBACK(on_button_clicked), NULL);
	draggable_actor = tangle_draggable_actor_new(clutter_actor);
	clutter_container_add_actor(CLUTTER_CONTAINER(container), draggable_actor);

	clutter_actor = clutter_texture_new_from_file("test_image_135x100.jpg", NULL);
	droppable_actor = tangle_droppable_actor_new(clutter_actor);
	/* g_object_set(droppable_actor, "dropping-enabled", FALSE, NULL); */
	clutter_container_add_actor(CLUTTER_CONTAINER(container), droppable_actor);
	
	clutter_actor_show_all(stage);	
	clutter_main();

	return 0;
}
