/*
 * tangle-event.c
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#include "tangle-event.h"

/**
 * SECTION:tangle-event
 * @short_description: Inter-actor events
 * @Title: TangleEvent
 */

TangleEvent* tangle_event_new(TangleEventType type, TangleActor* sender) {
	TangleEvent* event;
	
	event = g_slice_new0(TangleEvent);
	event->type = type;
	event->any.sender = sender;
	
	return event;
}

TangleEvent* tangle_event_copy(const TangleEvent* event) {
	TangleEvent* copy_of_event;
	
	g_return_val_if_fail(event != NULL, NULL);	

	copy_of_event = g_slice_new(TangleEvent);
	*copy_of_event = *event;
	
	return copy_of_event;
}

void tangle_event_free(TangleEvent* event) {
	if (G_LIKELY(event != NULL)) {
		g_slice_free(TangleEvent, event);
	}
}	

GType tangle_event_get_type(void) {
	static GType type = 0;

	if (!type)
		type = g_boxed_type_register_static("TangleEvent",
		                                    (GBoxedCopyFunc)tangle_event_copy,
		                                    (GBoxedFreeFunc)tangle_event_free);

	return type;
}
