/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

public class ImageTransfer
extends ByteArrayTransfer {
    private static ImageTransfer _instance = new ImageTransfer();
    private static final String JPEG = "image/jpeg";
    private static final int JPEG_ID = ImageTransfer.registerType("image/jpeg");
    private static final String PNG = "image/png";
    private static final int PNG_ID = ImageTransfer.registerType("image/png");
    private static final String BMP = "image/bmp";
    private static final int BMP_ID = ImageTransfer.registerType("image/bmp");
    private static final String EPS = "image/eps";
    private static final int EPS_ID = ImageTransfer.registerType("image/eps");
    private static final String PCX = "image/pcx";
    private static final int PCX_ID = ImageTransfer.registerType("image/pcx");
    private static final String PPM = "image/ppm";
    private static final int PPM_ID = ImageTransfer.registerType("image/ppm");
    private static final String RGB = "image/ppm";
    private static final int RGB_ID = ImageTransfer.registerType("image/ppm");
    private static final String TGA = "image/tga";
    private static final int TGA_ID = ImageTransfer.registerType("image/tga");
    private static final String XBM = "image/xbm";
    private static final int XBM_ID = ImageTransfer.registerType("image/xbm");
    private static final String XPM = "image/xpm";
    private static final int XPM_ID = ImageTransfer.registerType("image/xpm");
    private static final String XV = "image/xv";
    private static final int XV_ID = ImageTransfer.registerType("image/xv");

    private ImageTransfer() {
    }

    public static ImageTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkImage(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0)) {
            return;
        }
        ImageData imageData = (ImageData)object;
        if (imageData == null) {
            SWT.error(4);
        }
        Image image = new Image((Device)Display.getCurrent(), imageData);
        int n = image.pixmap;
        int n2 = imageData.width;
        int n3 = imageData.height;
        int n4 = OS.gdk_pixbuf_new(0, true, 8, n2, n3);
        if (n4 == 0) {
            SWT.error(2);
        }
        int n5 = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable(n4, n, n5, 0, 0, 0, 0, n2, n3);
        String string = "";
        if (transferData.type == JPEG_ID) {
            string = "jpeg";
        }
        if (transferData.type == PNG_ID) {
            string = "png";
        }
        if (transferData.type == BMP_ID) {
            string = "bmp";
        }
        if (transferData.type == EPS_ID) {
            string = "eps";
        }
        if (transferData.type == PCX_ID) {
            string = "pcx";
        }
        if (transferData.type == PPM_ID) {
            string = "ppm";
        }
        if (transferData.type == RGB_ID) {
            string = "rgb";
        }
        if (transferData.type == TGA_ID) {
            string = "tga";
        }
        if (transferData.type == XBM_ID) {
            string = "xbm";
        }
        if (transferData.type == XPM_ID) {
            string = "xpm";
        }
        if (transferData.type == XV_ID) {
            string = "xv";
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (byArray == null) {
            return;
        }
        OS.gdk_pixbuf_save_to_bufferv(n4, nArray, nArray2, byArray, null, null, null);
        OS.g_object_unref(n4);
        image.dispose();
        transferData.pValue = nArray[0];
        transferData.length = (nArray2[0] + 3) / 4 * 4;
        transferData.result = 1;
        transferData.format = 32;
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        ImageData imageData = null;
        if (transferData.length > 0) {
            int n = OS.gdk_pixbuf_loader_new();
            OS.gdk_pixbuf_loader_write(n, transferData.pValue, transferData.length, null);
            OS.gdk_pixbuf_loader_close(n, null);
            int n2 = OS.gdk_pixbuf_loader_get_pixbuf(n);
            if (n2 != 0) {
                OS.g_object_ref(n2);
                int[] nArray = new int[1];
                OS.gdk_pixbuf_render_pixmap_and_mask(n2, nArray, null, 0);
                int n3 = nArray[0];
                if (n3 == 0) {
                    SWT.error(2);
                }
                OS.g_object_unref(n);
                Image image = Image.gtk_new(Display.getCurrent(), 0, n3, 0);
                imageData = image.getImageData();
                image.dispose();
            }
        }
        return imageData;
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{JPEG_ID, PNG_ID, BMP_ID, EPS_ID, PCX_ID, PPM_ID, RGB_ID, TGA_ID, XBM_ID, XPM_ID, XV_ID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{JPEG, PNG, BMP, EPS, PCX, "image/ppm", "image/ppm", TGA, XBM, XPM, XV};
    }

    boolean checkImage(Object object) {
        return object != null && object instanceof ImageData;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkImage(object);
    }
}

