/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class ExpandBar
extends Composite {
    ExpandItem[] items;
    ExpandItem lastFocus;
    int itemCount;
    int spacing;
    int yCurrentScroll;

    public ExpandBar(Composite composite, int n) {
        super(composite, n);
    }

    public void addExpandListener(ExpandListener expandListener) {
        this.checkWidget();
        if (expandListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(expandListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (n != -1 && n < 0) {
                n = 0;
            }
            if (n2 != -1 && n2 < 0) {
                n2 = 0;
            }
            Point point = this.computeNativeSize(this.handle, n, n2, bl);
            int n3 = OS.gtk_container_get_border_width(this.handle);
            point.x += 2 * n3;
            point.y += 2 * n3;
            return point;
        }
        int n4 = 0;
        int n5 = 0;
        if ((n == -1 || n2 == -1) && this.itemCount > 0) {
            n4 += this.spacing;
            GC gC = new GC(this);
            for (int i = 0; i < this.itemCount; ++i) {
                ExpandItem expandItem = this.items[i];
                n4 += expandItem.getHeaderHeight();
                if (expandItem.expanded) {
                    n4 += expandItem.height;
                }
                n4 += this.spacing;
                n5 = Math.max(n5, expandItem.getPreferredWidth(gC));
            }
            gC.dispose();
        }
        if (n5 == 0) {
            n5 = 64;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n != -1) {
            n5 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n5, n4);
    }

    @Override
    void createHandle(int n) {
        this.state |= 8;
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
            if (this.fixedHandle == 0) {
                this.error(2);
            }
            OS.gtk_fixed_set_has_window(this.fixedHandle, true);
            this.handle = OS.gtk_vbox_new(false, 0);
            if (this.handle == 0) {
                this.error(2);
            }
            if ((this.style & 0x200) != 0) {
                this.scrolledHandle = OS.gtk_scrolled_window_new(0, 0);
                if (this.scrolledHandle == 0) {
                    this.error(2);
                }
                OS.gtk_scrolled_window_set_policy(this.scrolledHandle, 2, 1);
                OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
                OS.gtk_scrolled_window_add_with_viewport(this.scrolledHandle, this.handle);
                int n2 = OS.gtk_bin_get_child(this.scrolledHandle);
                OS.gtk_viewport_set_shadow_type(n2, 0);
            } else {
                OS.gtk_container_add(this.fixedHandle, this.handle);
            }
            OS.gtk_container_set_border_width(this.handle, 0);
        } else {
            int n3 = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
            if (n3 == 0) {
                this.error(2);
            }
            OS.gtk_fixed_set_has_window(n3, true);
            if ((this.style & 0x200) != 0) {
                this.fixedHandle = n3;
                this.scrolledHandle = OS.gtk_scrolled_window_new(0, 0);
                if (this.scrolledHandle == 0) {
                    this.error(2);
                }
                this.handle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
                if (this.handle == 0) {
                    this.error(2);
                }
                OS.gtk_fixed_set_has_window(this.handle, true);
                OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
                boolean bl = this.display.getWarnings();
                this.display.setWarnings(false);
                OS.gtk_container_add(this.scrolledHandle, this.handle);
                this.display.setWarnings(bl);
            } else {
                this.handle = n3;
            }
            OS.GTK_WIDGET_SET_FLAGS(this.handle, 2048);
        }
    }

    void createItem(ExpandItem expandItem, int n, int n2) {
        if (0 > n2 || n2 > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ExpandItem[] expandItemArray = new ExpandItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, expandItemArray, 0, this.items.length);
            this.items = expandItemArray;
        }
        System.arraycopy(this.items, n2, this.items, n2 + 1, this.itemCount - n2);
        this.items[n2] = expandItem;
        ++this.itemCount;
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && this.lastFocus == null) {
            this.lastFocus = expandItem;
        }
        expandItem.width = Math.max(0, this.getClientArea().width - this.spacing * 2);
        this.layoutItems(n2, true);
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.items = new ExpandItem[4];
    }

    void destroyItem(ExpandItem expandItem) {
        int n;
        for (n = 0; n < this.itemCount && this.items[n] != expandItem; ++n) {
        }
        if (n == this.itemCount) {
            return;
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && expandItem == this.lastFocus) {
            int n2;
            int n3 = n2 = n > 0 ? n - 1 : 1;
            if (n2 < this.itemCount) {
                this.lastFocus = this.items[n2];
                this.lastFocus.redraw();
            } else {
                this.lastFocus = null;
            }
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        expandItem.redraw();
        this.layoutItems(n, true);
    }

    @Override
    int eventHandle() {
        return OS.GTK_VERSION >= OS.VERSION(2, 4, 0) ? this.fixedHandle : this.handle;
    }

    @Override
    boolean forceFocus(int n) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (this.lastFocus != null && this.lastFocus.setFocus()) {
                return true;
            }
            for (int i = 0; i < this.itemCount; ++i) {
                ExpandItem expandItem = this.items[i];
                if (!expandItem.setFocus()) continue;
                return true;
            }
        }
        return super.forceFocus(n);
    }

    @Override
    boolean hasFocus() {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            for (int i = 0; i < this.itemCount; ++i) {
                ExpandItem expandItem = this.items[i];
                if (!expandItem.hasFocus()) continue;
                return true;
            }
        }
        return super.hasFocus();
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0) && this.scrolledHandle != 0) {
            OS.g_signal_connect_closure(this.scrolledHandle, OS.size_allocate, this.display.closures[47], true);
        }
    }

    int getBandHeight() {
        if (this.font == null) {
            return 24;
        }
        GC gC = new GC(this);
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        return Math.max(24, fontMetrics.getHeight());
    }

    @Override
    GdkColor getForegroundColor() {
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && (this.state & 0x1000) == 0) {
            return this.display.getSystemColor((int)30).handle;
        }
        return super.getForegroundColor();
    }

    public ExpandItem getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            this.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ExpandItem[] getItems() {
        this.checkWidget();
        ExpandItem[] expandItemArray = new ExpandItem[this.itemCount];
        System.arraycopy(this.items, 0, expandItemArray, 0, this.itemCount);
        return expandItemArray;
    }

    public int getSpacing() {
        this.checkWidget();
        return this.spacing;
    }

    @Override
    int gtk_button_press_event(int n, int n2) {
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0)) {
            GdkEventButton gdkEventButton = new GdkEventButton();
            OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
            int n3 = (int)gdkEventButton.x;
            int n4 = (int)gdkEventButton.y;
            for (int i = 0; i < this.itemCount; ++i) {
                boolean bl;
                ExpandItem expandItem = this.items[i];
                boolean bl2 = bl = expandItem.x <= n3 && n3 < expandItem.x + expandItem.width && expandItem.y <= n4 && n4 < expandItem.y + this.getBandHeight();
                if (!bl || expandItem == this.lastFocus) continue;
                this.lastFocus.redraw();
                this.lastFocus = expandItem;
                this.lastFocus.redraw();
                this.forceFocus();
                break;
            }
        }
        return super.gtk_button_press_event(n, n2);
    }

    @Override
    int gtk_button_release_event(int n, int n2) {
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && this.lastFocus != null) {
            boolean bl;
            GdkEventButton gdkEventButton = new GdkEventButton();
            OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
            int n3 = (int)gdkEventButton.x;
            int n4 = (int)gdkEventButton.y;
            boolean bl2 = bl = this.lastFocus.x <= n3 && n3 < this.lastFocus.x + this.lastFocus.width && this.lastFocus.y <= n4 && n4 < this.lastFocus.y + this.getBandHeight();
            if (bl) {
                Event event = new Event();
                event.item = this.lastFocus;
                this.notifyListeners(this.lastFocus.expanded ? 18 : 17, event);
                this.lastFocus.expanded = !this.lastFocus.expanded;
                this.showItem(this.lastFocus);
            }
        }
        return super.gtk_button_release_event(n, n2);
    }

    @Override
    int gtk_expose_event(int n, int n2) {
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0)) {
            GdkEventExpose gdkEventExpose = new GdkEventExpose();
            OS.memmove(gdkEventExpose, n2, GdkEventExpose.sizeof);
            GCData gCData = new GCData();
            gCData.damageRgn = gdkEventExpose.region;
            GC gC = GC.gtk_new(this, gCData);
            OS.gdk_gc_set_clip_region(gC.handle, gdkEventExpose.region);
            boolean bl = this.isFocusControl();
            for (int i = 0; i < this.itemCount; ++i) {
                ExpandItem expandItem = this.items[i];
                expandItem.drawItem(gC, bl && expandItem == this.lastFocus);
            }
            gC.dispose();
        }
        return super.gtk_expose_event(n, n2);
    }

    @Override
    int gtk_focus_in_event(int n, int n2) {
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && this.lastFocus != null) {
            this.lastFocus.redraw();
        }
        return super.gtk_focus_in_event(n, n2);
    }

    @Override
    int gtk_focus_out_event(int n, int n2) {
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && this.lastFocus != null) {
            this.lastFocus.redraw();
        }
        return super.gtk_focus_out_event(n, n2);
    }

    @Override
    int gtk_key_press_event(int n, int n2) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            int n3;
            int n4;
            if (!this.hasFocus()) {
                return 0;
            }
            int n5 = super.gtk_key_press_event(n, n2);
            if (n5 != 0) {
                return n5;
            }
            for (n4 = 0; n4 < this.itemCount && !this.items[n4].hasFocus(); ++n4) {
            }
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, n2, GdkEventKey.sizeof);
            boolean bl = false;
            switch (gdkEventKey.keyval) {
                case 65361: 
                case 65362: {
                    bl = false;
                    break;
                }
                case 65363: 
                case 65364: {
                    bl = true;
                    break;
                }
                default: {
                    return n5;
                }
            }
            int n6 = n4;
            int n7 = n3 = bl ? 1 : -1;
            while ((n4 = (n4 + n3 + this.itemCount) % this.itemCount) != n6) {
                ExpandItem expandItem = this.items[n4];
                if (!expandItem.setFocus()) continue;
                return n5;
            }
            return n5;
        }
        if (this.lastFocus != null) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, n2, GdkEventKey.sizeof);
            switch (gdkEventKey.keyval) {
                case 32: 
                case 65293: {
                    Event event = new Event();
                    event.item = this.lastFocus;
                    this.sendEvent(this.lastFocus.expanded ? 18 : 17, event);
                    this.lastFocus.expanded = !this.lastFocus.expanded;
                    this.showItem(this.lastFocus);
                    break;
                }
                case 65362: 
                case 65431: {
                    int n8 = this.indexOf(this.lastFocus);
                    if (n8 <= 0) break;
                    this.lastFocus.redraw();
                    this.lastFocus = this.items[n8 - 1];
                    this.lastFocus.redraw();
                    break;
                }
                case 65364: 
                case 65433: {
                    int n9 = this.indexOf(this.lastFocus);
                    if (n9 >= this.itemCount - 1) break;
                    this.lastFocus.redraw();
                    this.lastFocus = this.items[n9 + 1];
                    this.lastFocus.redraw();
                    break;
                }
            }
        }
        return super.gtk_key_press_event(n, n2);
    }

    public int indexOf(ExpandItem expandItem) {
        this.checkWidget();
        if (expandItem == null) {
            this.error(4);
        }
        for (int i = 0; i < this.itemCount; ++i) {
            if (this.items[i] != expandItem) continue;
            return i;
        }
        return -1;
    }

    void layoutItems(int n, boolean bl) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            for (int i = 0; i < this.itemCount; ++i) {
                ExpandItem expandItem = this.items[i];
                if (expandItem == null) continue;
                expandItem.resizeControl(this.yCurrentScroll);
            }
        } else {
            if (n < this.itemCount) {
                ExpandItem expandItem;
                int n2;
                int n3 = this.spacing - this.yCurrentScroll;
                for (n2 = 0; n2 < n; ++n2) {
                    expandItem = this.items[n2];
                    if (expandItem.expanded) {
                        n3 += expandItem.height;
                    }
                    n3 += expandItem.getHeaderHeight() + this.spacing;
                }
                for (n2 = n; n2 < this.itemCount; ++n2) {
                    expandItem = this.items[n2];
                    expandItem.setBounds(this.spacing, n3, 0, 0, true, false);
                    if (expandItem.expanded) {
                        n3 += expandItem.height;
                    }
                    n3 += expandItem.getHeaderHeight() + this.spacing;
                }
            }
            if (bl) {
                this.setScrollbar();
            }
        }
    }

    @Override
    int gtk_size_allocate(int n, int n2) {
        int n3 = super.gtk_size_allocate(n, n2);
        this.layoutItems(0, false);
        return n3;
    }

    @Override
    int parentingHandle() {
        return OS.GTK_VERSION >= OS.VERSION(2, 4, 0) ? this.fixedHandle : this.handle;
    }

    @Override
    void releaseChildren(boolean bl) {
        for (int i = 0; i < this.itemCount; ++i) {
            ExpandItem expandItem = this.items[i];
            if (expandItem == null || expandItem.isDisposed()) continue;
            expandItem.release(false);
        }
        super.releaseChildren(bl);
    }

    public void removeExpandListener(ExpandListener expandListener) {
        this.checkWidget();
        if (expandListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, expandListener);
        this.eventTable.unhook(18, expandListener);
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && bl2) {
            if ((this.style & 0x200) != 0) {
                this.setScrollbar();
            } else {
                for (int i = 0; i < this.itemCount; ++i) {
                    ExpandItem expandItem = this.items[i];
                    int n6 = Math.max(0, this.getClientArea().width - this.spacing * 2);
                    if (expandItem.width == n6) continue;
                    expandItem.setBounds(0, 0, n6, expandItem.height, false, true);
                }
            }
        }
        return n5;
    }

    @Override
    void setFontDescription(int n) {
        super.setFontDescription(n);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            for (int i = 0; i < this.itemCount; ++i) {
                this.items[i].setFontDescription(n);
            }
            this.layoutItems(0, true);
        }
    }

    @Override
    void setForegroundColor(GdkColor gdkColor) {
        super.setForegroundColor(gdkColor);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            for (int i = 0; i < this.itemCount; ++i) {
                this.items[i].setForegroundColor(gdkColor);
            }
        }
    }

    void setScrollbar() {
        Object object;
        int n;
        if (this.itemCount == 0) {
            return;
        }
        if ((this.style & 0x200) == 0) {
            return;
        }
        int n2 = this.getClientArea().height;
        ExpandItem expandItem = this.items[this.itemCount - 1];
        int n3 = expandItem.y + this.getBandHeight() + this.spacing;
        if (expandItem.expanded) {
            n3 += expandItem.height;
        }
        int n4 = OS.gtk_scrolled_window_get_vadjustment(this.scrolledHandle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, n4);
        this.yCurrentScroll = (int)gtkAdjustment.value;
        if (this.yCurrentScroll > 0 && n2 > n3) {
            this.yCurrentScroll = Math.max(0, this.yCurrentScroll + n3 - n2);
            this.layoutItems(0, false);
        }
        gtkAdjustment.value = Math.min(this.yCurrentScroll, n3 += this.yCurrentScroll);
        gtkAdjustment.upper = n3;
        gtkAdjustment.page_size = n2;
        OS.memmove(n4, gtkAdjustment);
        OS.gtk_adjustment_changed(n4);
        int n5 = n3 > n2 ? 0 : 2;
        OS.gtk_scrolled_window_set_policy(this.scrolledHandle, 2, n5);
        int n6 = OS.GTK_WIDGET_WIDTH(this.fixedHandle) - this.spacing * 2;
        if (n5 == 0) {
            n = OS.GTK_SCROLLED_WINDOW_VSCROLLBAR(this.scrolledHandle);
            object = new GtkRequisition();
            OS.gtk_widget_size_request(n, (GtkRequisition)object);
            n6 -= ((GtkRequisition)object).width;
        }
        n6 = Math.max(0, n6);
        for (n = 0; n < this.itemCount; ++n) {
            object = this.items[n];
            ((ExpandItem)object).setBounds(0, 0, n6, ((ExpandItem)object).height, false, true);
        }
    }

    public void setSpacing(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (n == this.spacing) {
            return;
        }
        this.spacing = n;
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.gtk_box_set_spacing(this.handle, n);
            OS.gtk_container_set_border_width(this.handle, n);
        } else {
            if ((this.style & 0x200) == 0) {
                int n2 = Math.max(0, this.getClientArea().width - n * 2);
                for (int i = 0; i < this.itemCount; ++i) {
                    ExpandItem expandItem = this.items[i];
                    if (expandItem.width == n2) continue;
                    expandItem.setBounds(0, 0, n2, expandItem.height, false, true);
                }
            }
            this.layoutItems(0, true);
            this.redraw();
        }
    }

    void showItem(ExpandItem expandItem) {
        Control control = expandItem.control;
        if (control != null && !control.isDisposed()) {
            control.setVisible(expandItem.expanded);
        }
        expandItem.redraw();
        int n = this.indexOf(expandItem);
        this.layoutItems(n + 1, true);
    }

    @Override
    void updateScrollBarValue(ScrollBar scrollBar) {
        this.yCurrentScroll = scrollBar.getSelection();
        this.layoutItems(0, false);
    }
}

