#ifndef CONFIGMANAGER_H
#define CONFIGMANAGER_H

#include <QObject>

#include <QList>
#include <QStringList>
#include <QVariant>

class ConfigManagerPrivate;

class ConfigManager : public QObject
{
    Q_OBJECT

public:
    explicit ConfigManager(QObject *parent = 0);
            ~ConfigManager();

    QList<QString> keys() const;

    QString      label      (const QString &key) const;
    QVariant     value      (const QString &key) const;
    int          valueIndex (const QString &key) const;

    void         addToggle  (const QString &key, const QString &label, bool initial = 0);
    void         addOption  (const QString &key, const QString &label, const QStringList &options, int initial = 0);

    void         prependToggle(const QString &key, const QString &label, bool initial = 0);
    void         prependOption(const QString &key, const QString &label, const QStringList &options, int initial = 0);

    bool         isToggle   (const QString &key) const;
    bool         isOption   (const QString &key) const;

    QStringList  options    (const QString &key) const;

signals:
    void         updated    (const QString &key, QVariant value);

public slots:
    void         setValue   (const QString &key, QVariant value);

private:
    ConfigManagerPrivate *d;
};

#endif // CONFIGMANAGER_H
