#ifndef MAEMO5TASKBUTTON_H
#define MAEMO5TASKBUTTON_H

#include <QtDBus>

#include <QEvent>
#include <QMainWindow>
#include <QToolButton>

class Maemo5TaskButton : public QToolButton
{
    Q_OBJECT

public:
    explicit inline Maemo5TaskButton (QMainWindow *parent) : QToolButton(parent)
    {
        QPalette palette = this->palette();
        palette.setColor(this->backgroundRole(), QColor(0, 0, 0, 96));
        this->setPalette(palette);

        this->setIcon(QIcon::fromTheme("filemanager_folder_up"));
        this->setFixedSize(this->sizeHint());
        this->setStyleSheet("QToolButton:pressed {border: none}");
        this->setAutoFillBackground(true);

        parent->installEventFilter(this);
        QObject::connect(this, SIGNAL(clicked()), this, SLOT(showDashboard()));
    }

protected slots:
    inline void showDashboard()
    {
        QDBusConnection::sessionBus().send(QDBusMessage::createSignal("/", "com.nokia.hildon_desktop", "exit_app_view"));
    }

protected:
    inline bool eventFilter(QObject *object, QEvent *event)
    {
        if(object == this->parent() && event->type() == QEvent::Resize)
        {
            QMainWindow *parent     = (QMainWindow*)this->parentWidget();

            bool         isFull     = parent->windowState() & Qt::WindowFullScreen;
            bool         isShown    = isFull;

            this->move(0, 0);
            this->setVisible(isShown);
            this->raise();
        }

        return QToolButton::eventFilter(object, event);
    }
};

#endif // MAEMO5TASKBUTTON_H
