#ifndef SPEEDINDICATOR_H
#define SPEEDINDICATOR_H

#include <QWidget>

class LCDIndicator : public QWidget
{
    Q_OBJECT

    Q_PROPERTY(qreal    value READ value WRITE setValue)
    Q_PROPERTY(QString  units READ units WRITE setUnitIndicator)

public:
    explicit     LCDIndicator (QWidget *parent = 0);

    int          heightForWidth (int width) const;

    qreal        value          () const;
    QString      units          () const;

signals:
    void         valueChanged   (qreal value);
    void         unitsChanged   (const QString &units);

public slots:
    void         setValue       (qreal value);
    void         setUnitIndicator       (const QString &units);

protected:
    void         paintEvent     (QPaintEvent *event);

private:
    qreal    m_Value;
    QString  m_Units;
};

#endif // SPEEDINDICATOR_H
