#ifndef MAEMO5FULLSCREENBUTTON_H
#define MAEMO5FULLSCREENBUTTON_H

#include <QEvent>
#include <QMainWindow>
#include <QToolButton>

class Maemo5FullScreenButton : public QToolButton
{
    Q_OBJECT

public:
    explicit inline Maemo5FullScreenButton(QMainWindow *parent) : QToolButton(parent)
    {
        QPalette palette = this->palette();
        palette.setColor(this->backgroundRole(), QColor(0, 0, 0, 96));
        this->setPalette(palette);

        this->setIcon(QIcon::fromTheme("general_fullsize"));
        this->setFixedSize(this->sizeHint());
        this->setStyleSheet("QToolButton:pressed {border:none}");
        this->setAutoFillBackground(true);

        parent->installEventFilter(this);
        QObject::connect(this, SIGNAL(clicked()), this, SLOT(toggleFullScreen()));
    }

protected slots:
    inline void toggleFullScreen()
    {
        QMainWindow *parent = qobject_cast<QMainWindow*>(this->parentWidget());

        if(parent->windowState() & Qt::WindowFullScreen)
        {
            parent->showNormal();
        }
        else
        {
            parent->showFullScreen();
        }
    }

protected:
    inline bool eventFilter(QObject *object, QEvent *event)
    {
        if(object == this->parent() && event->type() == QEvent::Resize)
        {
            QMainWindow *parent = qobject_cast<QMainWindow*>(this->parentWidget());

            this->move(parent->width() - this->width(), parent->height() - this->height());
            this->raise();
        }

        return QToolButton::eventFilter(object, event);
    }
};

#endif // MAEMO5FULLSCREENBUTTON_H
