#include "LCDIndicator.h"

#include <math.h>

#include <QPainter>

LCDIndicator::LCDIndicator(QWidget *parent)
    : QWidget(parent)
{
    QSizePolicy policy(QSizePolicy::Expanding, QSizePolicy::Preferred);
    policy.setHeightForWidth(true);
    this->setSizePolicy(policy);
    m_Value = 0.0;
}

int LCDIndicator::heightForWidth(int width) const
{
    return width / 2.3;
}

qreal LCDIndicator::value() const
{
    return m_Value;
}

void LCDIndicator::setValue(qreal value)
{
    m_Value = value;
    this->update();
    emit this->valueChanged(value);
}

QString LCDIndicator::units() const
{
    return m_Units;
}

void LCDIndicator::setUnitIndicator(const QString &units)
{
    m_Units = units;
    this->update();
    emit this->unitsChanged(units);
}

void LCDIndicator::paintEvent(QPaintEvent*)
{
    const int height = this->heightForWidth(this->width());
    const int i = floor(m_Value);
    const int d = (m_Value - i) * 100;

    QPalette palette = this->palette();
    QColor   bgColor = this->palette().background().color();

    bgColor.setAlphaF(0.5);
    palette.setColor(this->backgroundRole(), bgColor);
    this->setPalette(palette);

    const QString v1 = QString("%1").arg(QString::number(i), 3, '0');
    const QString v2 = QString(".%1").arg(QString::number(d), 2, '0');

    QPainter painter(this);
    painter.setRenderHint(QPainter::Antialiasing, true);
    painter.setPen(QPen(QColor(0xdf, 0xdf, 0xdf)));

    QFont font;
    font.setPixelSize(height);

    painter.setFont(font);
    painter.setMatrix(QMatrix());

    QRect rect1 = painter.boundingRect(0, 0, 0, 0, 0, v1);
    painter.translate(0, this->height() - rect1.height());
    painter.drawText(rect1, v1);

    font = QFont();
    font.setPixelSize(height / 2);

    painter.setFont(font);
    painter.setMatrix(QMatrix());

    QRect rect2 = painter.boundingRect(0, 0, 0, 0, 0, v2);
    painter.translate(rect1.width(), this->height() - rect1.height() + rect2.height() / 3);
    painter.drawText(rect2, v2);

    font = QFont();
    font.setPixelSize(height * 0.25);

    painter.setFont(font);
    QRect rect3 = painter.boundingRect(0, 0, 0, 0, 0, m_Units);

    painter.setMatrix(QMatrix());
    painter.translate(this->width() - rect3.width() * 1.2, this->height() - rect3.height() * 1.5);
    painter.drawText(rect3, m_Units);
}
