#include "MaemoApplicationDetails.h"
#include <QDebug>

MaemoApplicationDetails::MaemoApplicationDetails() {
            screenshots = new QList <QString>();
            userComments = new QList <MaemoComment*>();
            desc="";
            licence="";
            revisor="";
            installFile="";
            installFileContent="";
            status="";
            unparsedComments = new QString("");
 }

MaemoApplicationDetails::~MaemoApplicationDetails () {
    delete screenshots;
    delete userComments;
}

void MaemoApplicationDetails::setDesc (QString _desc) {
    this->desc = _desc;
}
void MaemoApplicationDetails::setLicence (QString _licence) {
    this->licence = _licence;
}

void MaemoApplicationDetails::setStatus (QString _status) {
    this->status = _status;
}
void MaemoApplicationDetails::setInstallFile (QString _installFile) {
    this->installFile = _installFile;
}

void MaemoApplicationDetails::setInstallFileContent (QString _installFileContent) {
    this->installFileContent = _installFileContent;
}

void MaemoApplicationDetails::setRevisor (QString _revisor) {
    this->revisor = _revisor;
}

void MaemoApplicationDetails::addScreenshot (QString _screenshot) {
    this->screenshots->append(_screenshot);
}

void MaemoApplicationDetails::addUserComment (MaemoComment *_userComment) {
    this->userComments->append (_userComment);
}

void MaemoApplicationDetails::setCommentsList (QList <MaemoComment*> *cl) {
    this->userComments = cl;
}

void MaemoApplicationDetails::setUnparsedComments (QString *c) {
    this->unparsedComments = c;
}

QString* MaemoApplicationDetails::getUnparsedComments() {
    qDebug() << "return unparsedComments";
    return this->unparsedComments;
}

QString MaemoApplicationDetails::getDescription () {
    return this->desc;
}

QString MaemoApplicationDetails::getLicence () {
    return this->licence;
}


QString MaemoApplicationDetails::getStatus () {
    return this->status;
}

QString MaemoApplicationDetails::getInstallFile () {
    return this->installFile;
}

QString MaemoApplicationDetails::getInstallFileContent () {
    return this->installFileContent;
}

QList <QString>* MaemoApplicationDetails::getScreenShots () {
    return screenshots;
}

QString MaemoApplicationDetails::getFirstScreenShot () {
    if (screenshots->length() >0) {
        return screenshots->at(0);
    } else {
        return "";
    }
}

QList <MaemoComment*>* MaemoApplicationDetails::getUserComments () {
    return userComments;
}


QString MaemoApplicationDetails::toString () {
    return  "\ndescription: " + desc +
            "\nlicence: " + licence +
            "\nversion: " + this->getVersion() +
            "\nstatus: " + status +
            "\nInstallFile: " + installFile +
            "\nInstallFileContent: " + installFileContent +
            "\ndownloads: " + getDownloads() +
            "\nrating: " + getRating() +
            "\nrevisor: " + revisor;
}
