#ifndef HTTPCONNECTOR_H
#define HTTPCONNECTOR_H

#include <QObject>
#include <QtNetwork>
#include <QTextStream>
#include <QTimer>
#include <QNetworkReply>
#include <QNetworkAccessManager>
#include <QNetworkDiskCache>
#include <QNetworkProxy>
#include <QByteArray>



class HttpConnector : public QObject {	
	Q_OBJECT
	
	public:
                //constructors
                HttpConnector();
                HttpConnector(int, int=0);

                void setProxy (QString,int);
                void getRequest (QString);
                void postRequest (QUrl,QByteArray);
                bool isBusy ();
                bool hasCookieForUrl (QUrl);
                void resetCookies ();

        public slots:
                void readResponse ();

	
        private slots:
                void setRequestTimeout ();

        signals:
                void getResponseContent (QByteArray,int);
                void isFree();

        private:
                QNetworkAccessManager *http;
                QNetworkDiskCache *cache;
                QNetworkReply *reply;
                QNetworkCookieJar *cookies;
                int timeout;
                QTimer *timer;
                bool busy;
                QByteArray response;
};

#endif
