/**
 * Copyright (C) 2009 Tan Miaoqing
 * Contact: Tan Miaoqing <rabbitrun84@gmail.com>
 */

#include <glib/gstdio.h>

#include "twitter_util.h"

/* Store the ID of last retrieved reply */
#define CONFIG_DIR ".libpurple-twitter-protocol"
#define CONFIG_FILE "config"

long long purple_account_get_long_long(PurpleAccount *account, const gchar *key, long long default_value)
{
	const char* tmp_str;

	tmp_str = purple_account_get_string(account, key, NULL);
	if(tmp_str)
		return strtoll(tmp_str, NULL, 10);
	else
		return 0;
}

void purple_account_set_long_long(PurpleAccount *account, const gchar *key, long long value)
{
	gchar* tmp_str;

	tmp_str = g_strdup_printf("%lld", value);
	purple_account_set_string(account, key, tmp_str);
	g_free(tmp_str);
}


//TODO: move those
#if _HAVE_PIDGIN_
static const char *_find_first_delimiter(const char *text, const char *delimiters, int *delim_id)
{
	const char *delimiter;
	if (text == NULL || text[0] == '\0')
		return NULL;
	do
	{
		for (delimiter = delimiters; *delimiter != '\0'; delimiter++)
		{
			if (*text == *delimiter)
			{
				if (delim_id != NULL)
					*delim_id = delimiter - delimiters;
				return text;
			}
		}
	} while (*++text != '\0');
	return NULL;
}
#endif

//TODO: move those
static const char *twitter_linkify(PurpleAccount *account, const char *message)
{
#if _HAVE_PIDGIN_
	GString *ret;
	static char symbols[] = "#@";
	static char *symbol_actions[] = {TWITTER_URI_ACTION_SEARCH, TWITTER_URI_ACTION_USER};
	static char delims[] = " :"; //I don't know if this is how I want to do this...
	const char *ptr = message;
	const char *end = message + strlen(message);
	const char *delim = NULL;
	g_return_val_if_fail(message != NULL, NULL);

	ret = g_string_new("");

	while (ptr != NULL && ptr < end)
	{
		const char *first_token = NULL;
		char *current_action = NULL;
		char *link_text = NULL;
		int symbol_index = 0;
		first_token = _find_first_delimiter(ptr, symbols, &symbol_index);
		if (first_token == NULL)
		{
			g_string_append(ret, ptr);
			break;
		}
		current_action = symbol_actions[symbol_index];
		g_string_append_len(ret, ptr, first_token - ptr);
		ptr = first_token;
		delim = _find_first_delimiter(ptr, delims, NULL);
		if (delim == NULL)
			delim = end;
		link_text = g_strndup(ptr, delim - ptr);
		//Added the 'a' before the account name because of a highlighting issue... ugly hack
		g_string_append_printf(ret, "<a href=\"" TWITTER_URI ":///%s?account=a%s&text=%s\">%s</a>",
				current_action,
				purple_account_get_username(account),
				purple_url_encode(link_text),
				purple_markup_escape_text(link_text, -1));
		ptr = delim;
	}

	return g_string_free(ret, FALSE);
#else
	return message;
#endif
}

//TODO: move those
char *twitter_format_tweet(PurpleAccount *account, const char *src_user, const char *message, long long id)
{
	const char *linkified_message = twitter_linkify(account, message);
	gboolean add_link = twitter_option_add_link_to_tweet(account);

	g_return_val_if_fail(linkified_message != NULL, NULL);
	g_return_val_if_fail(src_user != NULL, NULL);

	if (add_link && id) {
		return g_strdup_printf("%s\nhttp://twitter.com/%s/status/%lld\n",
				linkified_message,
				src_user,
				id);
	}
	else {
		return g_strdup_printf("%s", linkified_message);
	}
}

long long get_stored_last_reply_id (const gchar *accont_username)
{
	gchar *file, *config_file;
	long long reply_id = 0;

	config_file = g_strdup_printf ("%s-%s", accont_username, CONFIG_FILE);
	file = g_build_filename (
	g_get_home_dir(),
	CONFIG_DIR,
	config_file,
	NULL);

	if (g_file_test (file, G_FILE_TEST_EXISTS)) {
		FILE *pFile = g_fopen (file, "r");

		if (pFile) {
			fscanf (pFile, "%lld", &reply_id);

			/* TODO sometimes reply_id could be 0?????
			* Reading failure???????????????? */

			fclose (pFile);
		}
	}

	g_free (config_file);
	g_free (file);

	return reply_id;
}

void store_last_reply_id (const gchar *username,
		long long last_reply_id)
{
	gchar *config_file;
	gchar *file;
	FILE *pFile;

	config_file = g_strdup_printf ("%s-%s",
		username, CONFIG_FILE);
	file = g_build_filename (
	    g_get_home_dir(),
	    CONFIG_DIR,
	    config_file,
	    NULL);

	pFile = g_fopen (file, "w");
	fprintf (pFile, "%lld\n", last_reply_id);

	fclose (pFile);
	g_free (config_file);
	g_free (file);
}

void create_config_path ()
{
	gchar *dir;

        /* Check whether director ~/.libpurple-twitter-protocol
         * exists or not. Create it if not */
	dir = g_build_filename (g_get_home_dir(), CONFIG_DIR, NULL);
	if (g_file_test (dir, G_FILE_TEST_EXISTS) == FALSE) {
		if (g_mkdir (dir, S_IRWXU) != 0) {
		  // TODO what if fail?
		}
	}
	g_free (dir);
}

/* If host is x.y/z (e.g. twitk.com/k),
 * Host url should be x.y (e.g. twitk.com) */
gchar **get_host_url (const char *host)
{
	if (!host || host[0] == '\0')
		return NULL;

	return g_strsplit (host, "/", 2);
}
