/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Copyright 2008-2011 LUT. .
 *
 * @name WLANListenerCreator.h
 * @memo 
 *
 * @version 0.1
 * date     14.4.2011
 * change   14.4.2011
 */

#ifndef __WLANLISTENERCREATOR_H__
#define __WLANLISTENERCREATOR_H__

#include <syslog.h>
#include "AbstractListenerCreator.h"


#ifdef PH_DEBUG
#define DBG(format, msg...) syslog(LOG_DEBUG, format "\n" , ## msg)
#else
#define DBG(A...)
#endif

/**
 * @memo WLAN specific implementation of MAbstractListenerCreator
 * @doc Creates CWLANListener-objects (with "wlan" as aName param.) Instance
 * of this is initialized when plugin-listener-wlan is loaded and automatically registers
 * itself to ListenerFactory, so initialization should be dynamic.
 * 
 * @see MAbstractListenerCreator
 * @see MabstractListener
 * @see MAbstractStateConverter
 * @see ListenerFactory
 */
class CWLANListenerCreator : public MAbstractListenerCreator
{
public:
	CWLANListenerCreator();
	MAbstractListener* CreateListener(const std::string& aName, MAbstractStateConverter* aConverter);
	
private:
	// Prototype name
	std::string iProto;
};

#endif /*WLANLISTENERCREATOR_H_*/
