/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Copyright 2008 LUT. .
 *
 * @name MaemoBTCreator.cc
 * @memo Maemo bt-specific implementation of MAbstractListenerCreator
 *
 * @version 0.16
 * date     14.11.2008
 * change   16.12.2008
 */

#ifndef __MAEMOBTCREATOR_H_
#define __MAEMOBTCREATOR_H_

#include <syslog.h>
#include "AbstractListenerCreator.h"

#define ERR(format, msg...) syslog(LOG_ERR, "ERROR: " format "\n" , ## msg)

#ifdef PH_DEBUG
#define DBG(format, msg...) syslog(LOG_DEBUG, format "\n" , ## msg)
#else
#define DBG(A...)
#endif

/**
 * @memo Maemo BT specific impelementation of MAbstractListenerCreator. Used only via
 * ListenerFactory by any class that implements MAbstractStateConverter-interface.
 * @doc Loaded by PeerHood daemon dynamically as a library, automatically registers itself into
 * ListenerFactory. Can be used to create MaemoBTListener objects that is a listener object for 
 * bluetooth in Maemo that uses btcond D-Bus interface. Creates the listener if requested type is "bt".
 * An instance of this class is created by using a static variable.
 * 
 * @see MaemoBTListener
 * @see MAbstractListenerCreator
 * @see MabstractListener
 * @see MAbstractStateConverter
 */
class CMaemoBTCreator : public MAbstractListenerCreator
{
public:
	CMaemoBTCreator();
	MAbstractListener* CreateListener(const std::string& aName, MAbstractStateConverter* aConverter);
	
private:
	std::string iProto;
	
};

#endif /* __MAEMOBTCREATOR_H_*/
