/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003 LUT. .
 *
 * @name DeviceStorage.h
 * @memo Class that is used as a database for all device & service related
 * information.
 *
 * @version 0.1
 * date     01.04.2003
 * change   01.04.2003
 */

#ifndef __DEVICESTORAGE_H__
#define __DEVICESTORAGE_H__

#include <pthread.h>
#include <DaemonDevice.h>

typedef std::list<CDaemonDevice *>& TDEVICE_LIST;
typedef std::list<CDaemonDevice *>::iterator TDEVICE_ITERATOR;

/**
 * @memo Class used as a database for all device & service related information.
 * @doc Class used as a database for all device & service related information.
 * Every device is stored as a MAbstractDevice object and services of the
 * device are stored in that object. The implementation of this class follows
 * the singleton design pattern so at any given moment of time there should 
 * exist only one instance of this class. Note that this class is thread-safe.
 *
 * @see MAbstractDevice
 */
class CDeviceStorage
{
 public:
  static CDeviceStorage* GetInstance();
  void Update(const char* aProto, const std::list<CDaemonDevice *>& aList);
  TDEVICE_ITERATOR FirstDevice();
  TDEVICE_ITERATOR LastDevice();
  void ReleaseDeviceList();
  const TDEVICE_LIST GetDeviceList();

 protected:
  CDeviceStorage();
  CDeviceStorage(const CDeviceStorage&);
  const CDeviceStorage& operator= (const CDeviceStorage&);

 private:
  static CDeviceStorage* iInstance;
  inline void Lock();
  inline void Unlock();
  
  std::list<CDaemonDevice *> iDeviceList;
  pthread_mutex_t iLock;
};

#endif // __DEVICESTORAGE_H__
