#ifndef PROTOREDECEDE_H_
#define PROTOREDECEDE_H_

#define SERVICE_NAME "rExe"
#define SIZE_MSG 500
#define MSG_ASK_POWER 'a'
#define MSG_ANS_POWER 'b'
#define MSG_ASK_LATENCY 'c'
#define MSG_ANS_LATENCY 'd'
#define MSG_SEND_TASK 'e'
#define MSG_ANS_TASK 'f'
#define MSG_SEND_DATA_RATE 'g'

//informations about the device able to do a remote computation
typedef struct sdev_info{
  //device name
  std::string name;
  //device address
  std::string address;
  //type of connection
  std::string proto;
  // processor power indication
  int processor;
  // memory indication        
  unsigned long memory;
}tdev_info;

//information about the task to be done
typedef struct stask_info{
  //memory in Mo
  unsigned long memory;
  // time in s
  float time_ref;
  //size of communications in ko
  int size_to_send;
  int size_to_receive;
}ttask_info;

//informations about the link
typedef struct slink_info{
  int rate;
  int quality;
}tlink_info;


#endif /*PROTOREDECEDE_H_*/
