#include <iostream>
#include <unistd.h>
#include <cstdio>
#include <signal.h>
#include <sstream>
#include <sys/types.h>
#include <PeerHood.h>
#include <netinet/in.h>
#include <time.h>
#include <fstream>
#include <stdlib.h>
#include <string.h>

#include "proto-REdecide.h"
#include "param.h"
#include "hot_cube.h"

#include <AbstractPlugin.h>

using namespace std;

map<const char*, MAbstractPlugin*> pluginMap;

static volatile bool run = true;
static MAbstractConnection* connection = NULL;

// callback interface plugin
class ServerCallback : public CBasicCallback
{
  public:
  // from the CBasicCallback
  void Notify(TEventType aEvent, const string& aAddress) 
  {
    cout << "Got an event!" << endl;
  };

  void NewConnection(const unsigned short aPort, MAbstractConnection* aConnection, int aConnectionId) 
  {
    connection = aConnection; 
    std::cout << "ServerCallback::NewConnection : Got connection Id " << aConnectionId << " port " << aPort << std::endl;
  };

};


void SignalHandler(int aSignal){
  cerr << "Ouch! Hit by a fatal signal!" << endl;
  run = false;
}

int main(int argc, char** argv){
  MPeerHood* peerHood;
  ServerCallback* callback = new ServerCallback;
  
  fd_set set;
  //char cmd;

  peerHood = MPeerHood::GetInstance(callback);

  if (!peerHood->Init(argc, argv)) {
    cerr << "PeerHood initialization failed!" << endl;
    exit(EXIT_FAILURE);
  }
  
  signal(SIGTERM, SignalHandler);
  signal(SIGINT, SignalHandler);
   
  tdev_info dev_info;
  dev_info = define_param();
    
  if ((peerHood->RegisterService(string("rExe"), string("Remote execution device capable"),string("44444"))) == 0) {
            cerr << "Registration failed !" << endl;
            exit(EXIT_FAILURE);
          }else{
            cout << "registration succesful" << endl;
          }
  struct timeval timeVal;
  int length;
  char* buffer;
  stringstream strs;
  string sendbuffer;
  int sendlength;
  
  while (run) {
    if (!connection){
      sleep(1);
    }else{
      FD_ZERO(&set);
      FD_SET(connection->GetFd(), &set);
      timeVal.tv_sec = 3;
      timeVal.tv_usec = 0;
      switch (select(connection->GetFd() + 1, &set, NULL, NULL, &timeVal)){
        case -1:
          //break;    
        case 0:
          break;
        default:
          if (FD_ISSET(connection->GetFd(), &set)){
            int actualRead = 0;
            actualRead = connection->Read(&length, sizeof(length)); 
            if(actualRead != sizeof(length)){
              delete connection;
              connection = NULL;
              std::cout << "Quality 1, received " << actualRead  << std::endl;
            }else{
              length = ntohl(length);
              buffer = new char[length + 1];
              bzero(buffer, length + 1);
              if(connection->Read(buffer, length) != length){
                delete[] buffer;
                delete connection;
                connection = NULL;
                std::cout << "Receiving message failed" << std::endl;
                break;
              }
              //cout << "[message] " << buffer << endl;
              
              switch (buffer[0]) {
                
                case MSG_ASK_POWER :                                    
                  strs << "bProcessor:" << dev_info.processor << ",Memory:" << dev_info.memory << endl;
                  sendbuffer = strs.str();                
                  sendlength = htonl(sendbuffer.length());
                  connection->Write(&sendlength, sizeof(sendlength));
                  connection->Write(sendbuffer.c_str(), sendbuffer.length());
                  break;
                  
                case MSG_SEND_DATA_RATE :
                {
                int nbc=0;
                ifstream fichier1("end.bin", ios::in);
                  char caract;
                  int nbwrite =0;
                  while(fichier1.get(caract)){
                    strs << caract ;
                    nbc++;
                    if(nbc==SIZE_MSG){
                        sendbuffer = strs.str();
                        sendlength = htonl(sendbuffer.length());
                        nbwrite++;
                        cout << nbwrite << " file 1 " << endl;
                        connection->Write(&sendlength, sizeof(sendlength));
                        connection->Write(sendbuffer.c_str(), sendbuffer.length());
                        nbc=0;
                        strs.str("");
                        //sleep(1);
                    } 
                  }                                    
                  if(nbc!=0){
                    sendbuffer = strs.str();
                    sendlength = htonl(sendbuffer.length());
                    connection->Write(&sendlength, sizeof(sendlength));
                    connection->Write(sendbuffer.c_str(), sendbuffer.length());
                    sleep(1);
                    nbc=0;
                  }
                  sendlength = htonl(nbc);
                  connection->Write(&sendlength, sizeof(sendlength));
                  }
                  break;
                  
                case MSG_ASK_LATENCY :
                  clock_t Start;
                  clock_t End;
                  Start = clock();
                  strs << MSG_ANS_LATENCY << "1" << endl;
                  sendbuffer = strs.str();                
                  sendlength = htonl(sendbuffer.length());
                  connection->Write(&sendlength, sizeof(sendlength));
                  connection->Write(sendbuffer.c_str(), sendbuffer.length());
                  End = clock();
                  cout << "remove from latency " << clockdiffToSeconds(Start,End) << endl;
                  break;
                case MSG_SEND_TASK :
                  {
                  string tempstring;
                  string tempstring2 = buffer+1;
                  std::vector<int> param;
                  int loc=0;             
                  while(loc!=-1){
                    loc = tempstring2.rfind(';');
                    if (loc == -1){
                      tempstring = tempstring2;
                    }else{
                      tempstring = tempstring2.substr(loc+1);
                    }
                    tempstring2=tempstring2.substr(0,loc);
                    param.push_back(atoi(tempstring.c_str()));                  
                  }
                  //strs << MSG_SEND_TASK<<nb_it<<";"<<w<<";"<<h<<";"<<out_tp<<";"<<in_tp<<";"<<s;
                  int w = param[4]; 
                  int h = param[3]; 
                  int s = param[0];
                  int nb_it = param[5];
                  int out_tp = param[2];
                  int in_tp = param[1];
                  std::vector< std::vector< float > > tempe(w*s,std::vector<float>(h*s,in_tp));
                  tempe = algo(nb_it,w, h,out_tp,tempe,s);
                  cout << "construct snd msg" << endl;
                  //strs << MSG_ANS_TASK;
                  string ligne;
                  ifstream fichier1("end.bin", ios::in);
                  ifstream fichier2("end.png", ios::in);
                  int nbc=0;
                  char caract;
                  int nbwrite =0;
                  while(fichier1.get(caract)){
                    strs << caract ;
                    nbc++;
                    if(nbc==SIZE_MSG){
                        sendbuffer = strs.str();
                        sendlength = htonl(sendbuffer.length());
                        nbwrite++;
                        cout << nbwrite << " file 1 " << endl;
                        connection->Write(&sendlength, sizeof(sendlength));
                        connection->Write(sendbuffer.c_str(), sendbuffer.length());
                        nbc=0;
                        strs.str("");
                        //sleep(1);
                    } 
                  }
                  strs << ";";
                  nbc++;
                  if(nbc==SIZE_MSG){
                        sendbuffer = strs.str();
                        sendlength = htonl(sendbuffer.length());
                        nbwrite++;
                        
                        connection->Write(&sendlength, sizeof(sendlength));
                        connection->Write(sendbuffer.c_str(), sendbuffer.length());
                        nbc=0;
                        strs.str("");
                        //sleep(1);
                    } 
                  while(fichier2.get(caract)){
                    strs << caract ;
                    nbc++;
                    if(nbc==SIZE_MSG){
                        sendbuffer = strs.str();
                        sendlength = htonl(sendbuffer.length());
                        nbwrite++;
                        connection->Write(&sendlength, sizeof(sendlength));
                        connection->Write(sendbuffer.c_str(), sendbuffer.length());
                        nbc=0;
                        strs.str("");
                        //sleep(1);
                    } 
                  }
                  if(nbc!=0){
                    sendbuffer = strs.str();
                    sendlength = htonl(sendbuffer.length());
                    connection->Write(&sendlength, sizeof(sendlength));
                    connection->Write(sendbuffer.c_str(), sendbuffer.length());
                    sleep(1);
                    nbc=0;
                  }
                  sendlength = htonl(nbc);
                  connection->Write(&sendlength, sizeof(sendlength));                 
                  }
                  break;
                  
                default :
                  cout << "je ne sais pas" << endl;
                  
              }
              strs.str("");             
              delete[] buffer;
              delete connection;
              connection = NULL;
            }
          }else{
            std::cout << "TimeOut" << std::endl;
          }
      }
    }
  }
  
  peerHood->UnregisterService(string(SERVICE_NAME));
  delete peerHood;
  
  
  return EXIT_SUCCESS;
}

