/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003 LUT. .
 *
 * @name GPRSPinger.h
 * @memo GPRS specific realization of the MAbstractPinger interface.
 *
 * @version 0.1
 * date     30.06.2003
 * change   14.11.2003
 */

#ifndef __GPRSPINGER_H__
#define __GPRSPINGER_H__

#include <string>
#include <AbstractPinger.h>

/**
 * @memo GPRS specific realization of the MAbstractPinger interface.
 * @doc GPRS specific realization of the MAbstartactPinger interface.
 * Pinging is done by sending the ECHO messages. If there's no response
 * in one seconds time then the remote device is assumed to be out of range.
 *
 * @see MAbstractPinger
 */
class CGPRSPinger : public MAbstractPinger
{
 public:
  CGPRSPinger(const std::string& aAddress);
  const std::string& GetAddress();
  bool InRange();
  bool Ping();

 private:
  bool iInRange;
  std::string iAddress;
  u_short in_cksum(u_short *addr, int len);
};

#endif // __GPRSPINGER_H__
