/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Copyright 2003 LUT. .
 *
 * @name GPRSMonitor.cc
 * @memo GPRS implementation of the MAbstractMonitor interface.
 *
 * @version 0.1
 * date     31.07.2003
 * change   31.07.2003
 */
#include <iostream>
#include <stdlib.h>
#include <GPRSMonitor.h>

//temp
#include <syslog.h>

#define ERR(format, msg...) syslog(LOG_ERR, "ERROR: " format "\n" , ## msg)

#ifdef PH_DEBUG
#define DBG(format, msg...) syslog(LOG_DEBUG, format "\n" , ## msg)
#else
#define DBG( A... )
#endif
//temp

/**
 * @memo Constructor.
 * @doc Constructor, initializes the pinger object so that it can be used
 * immediately after the construction has finished.
 *
 * @param aAddress Remote device's address.
 *
 * @return none
 */
CGPRSMonitor::CGPRSMonitor(const std::string& aAddress) : MAbstractMonitor(aAddress)
{
  iAddress = std::string(aAddress);
  iInRange = true;
}

CGPRSMonitor::~CGPRSMonitor()
{
}

/**
 * @memo Monitores the connection. Returns always 1.
 * @doc Monitores the connection. Returns always 1.
 *
 * @return always 1
 */
int CGPRSMonitor::Monitor()
{
  return 1;
};


/**
 * @memo Returns remote device's GPRS address.
 * @doc Return the GPRS address of the device under monitoring.
 *
 * @return remote device's address
 */
const std::string& CGPRSMonitor::GetAddress()
{
  return iAddress;
}


/**
 * @memo Tells whether a device is in range or not.
 * @doc Tells whether a device is in range or not.
 *
 * @return true if the device is in range
 */
bool CGPRSMonitor::InRange()
{
  return iInRange;
}

