/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003 LUT. .
 *
 * @name GPRSDevice.h
 * @memo Defines messages and structures used by GPRSPlugin and GPRSGateway
 *
 * @version 0.1
 * date     29.08.2003
 * change   13.11.2003
 */

#ifndef __GPRSDEVICE_H__
#define __GPRSDEVICE_H__

#include <string>

#define GETID ((int) 0)           //Id query message
#define REPID ((int) 1)           //Response for id query
#define ADVERT ((int) 2)          //Advert info message
#define REPADVERT ((int) 3)       //Response for advert message
#define GETDEV ((int) 4)          //Device query message
#define REPDEV ((int) 5)          //Response for device query message
#define DEVICE ((int) 6)          //Device info message
#define GETSERV ((int) 7)         //Service request message
#define DATA ((int) 8)            //Data info message
#define SERVDISCONN ((int) 9)     //Service disconnection info message
#define PROBE ((int) 10)          //Gateway probe message
#define REPPROBE ((int) 11)       //Gateway probe reply message
#define REPSERV ((int) 12)        //Response for service query message
#define SERVICE ((int) 13)        //Service info message
#define GETSERVREP ((int) 14)      //Service request reply header
#define SERVICEADVERT ((int) 15)
#define CONNECT ((int) 16)
#define REPCONNECT ((int) 17)
#define DEVICEINFO ((int) 18)     //device name and checksum
#define REQ ((int) 19)            //request for starting device&service query
#define REPREQ ((int) 20)         //reply for request
#define REQCOMPLETE ((int) 21)    //request complete
#define HOLD ((int) 22)
class MAbstractConnection;

//Gateway Info
//information for Gateway to identify filedescriptors by given id number
class CGPRSDevice
{
 public:
  unsigned int iId;
  int iSignalFd;
  int iDataFd;
  int iStatus;
  bool iChecked;
};

//Plugin Info
//information for plugin to inquire devices and services
class CGPRSInquiry
{
public:
  unsigned int iDeviceId;
  unsigned int iServices;
  unsigned int iServicesReceived;
  bool iShouldCheck;
  bool iDeviceChecked;
};

//Plugin Info
//Used by data thread to form up connection
class CGPRSDataConnection
{
 public:
  unsigned int iOriginalId;
  unsigned int iOriginalFd;
  std::string iServiceName;
};


//PDU used by plugin and gateway for communication
class CGPRSSignal
{
public:
  unsigned int iMessageType; //message type
  unsigned int iOriginalId; //original sender id
  unsigned int iData; //additional data
  unsigned int iData2;
  std::string iServiceName;
};




#endif // __GPRSDEVICE_H__
