/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Copyright 2003 LUT. .
 *
 * @name LibDevice.cc
 * @memo Implementation of the MAbstractDevice. This version is used by the 
 * PeerHood library (and software developers using the library).
 *
 * @version 0.1
 * date     17.04.2003
 * change   17.04.2003
 */

#include <iostream>
#include "LibDevice.h"

/**
 * @memo Constructor that creates the object from the given marshalled data.
 * @doc Constructor that creates the object from the given marshalled data.
 * This data also includes information about the services offered by the
 * device.
 *
 * @param aData Marshalled data to be encoded.
 *
 * @return none
 */
CLibDevice::CLibDevice(const char* aData)
{
  int position;
  CService* temp;

  iAddress = std::string(&aData[10]);
  iPrototype = std::string(&aData[10 + aData[0] + 1]);
  iName = std::string(&aData[10 + aData[0] + aData[1] + 2]);
  iReferrerName = std::string(&aData[10 + aData[0] + aData[1] + aData[3] + 3]);
  iHasPeerHood = (bool)aData[2];
  memcpy(&iChecksum, &aData[5], sizeof(iChecksum));

  // unmarshal services
  // aData fields: 0: Addr len, 1: proto len, 3: name len, 4: ref len
  position = 10 + (aData[0]+1) + (aData[1]+1) + (aData[3]+1) + (aData[4]+1);
  //  position = 10 + iAddress.length() + iPrototype.length() + iName.length() +iReferrerName.length() + 4;

  for (int i = 0;i < aData[9];i++) {
    temp = new CService(&aData[position]);
    position += temp->MarshalledLength();
    AddService(temp);
  }
  
}
